<?php

namespace App\Form;

use App\Entity\Tdestino;
use App\Entity\Tempresa;
use App\Entity\Tnacional;
use App\Entity\Torigen;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\DateType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

class TnacionalType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('fechainicio',DateType::class, array(
                'widget'=>'single_text',
                'html5' => false,
                'input' => 'datetime',
                'label'=>'Fecha de Recepción',
                'format'=>'dd/MM/yyyy',
                'attr'=> ['class'=>'form-control mydatepicker', 'style' => 'margin-bottom:5px','placeholder'=>'dd/mm/yyyy']))

//            ->add('factura',TextType::class,
//                array('label'=>'Factura',
//                    'attr'=>array('class'=>'form-control', 'style' => 'margin-bottom:10px', 'maxlength'=>8, 'onkeypress'=>'return controlnum(event)')))

            ->add('observaciones',TextType::class,
                array('label'=>'Observaciones',
                    'attr'=>array(
                        'class'=>'form-control',
//                        'class'=>'textarea_editor form-control',
//                        'rows' => '5',
                        'style' => 'margin-bottom:10px',
                        'maxlength'=>1000)))

//            ->add('auditoria')

            ->add('iddestino', EntityType::class, [
                'label' => 'Lugar de Destino',
                'attr'=>array('class'=>'form-control', 'style' => 'margin-bottom:10px'),
                'class' => Tdestino::class,
                'placeholder' => '---- Escoge un destino',
                'query_builder' => function ($er) {
                    return $er->createQueryBuilder('p')
                        ->select('p') // Entity Persona
//						->from(Persona::class, 'p')
                        ->where('p.abreviacion=:tipoPersona ')
                        ->setParameter('tipoPersona', 'Nacional')
                        ->orderBy('p.descripcion', 'ASC');
                },
            ])

            ->add('idempresa', EntityType::class, [
                'label' => 'Empresa',
                'attr'=>array('class'=>'form-control', 'style' => 'margin-bottom:10px'),
                'class' => Tempresa::class,
                'placeholder' => '---- Escoge una empresa',
                ])

//            ->add('idestado')
//            ->add('archivo',FileType::class, array(
//                'required'=>true,
//                'attr'=>array('class'=>'form-control dropify', 'style' => 'margin-bottom:10px'),
//                'label'=>'Documento de Respaldo',
//                'data_class'=>null))
            ->add('idorigen', EntityType::class, [
                'label' => 'Lugar de Origen',
                'attr'=>array('class'=>'form-control', 'style' => 'margin-bottom:10px'),
                'class' => Torigen::class,
                'placeholder' => '---- Escoge un origen',
                'query_builder' => function ($er) {
                    return $er->createQueryBuilder('p')
                        ->select('p') // Entity Persona
//						->from(Persona::class, 'p')
                        ->where('p.abreviacion=:tipoPersona ')
                        ->setParameter('tipoPersona', 'Nacional')
                        ->orderBy('p.descripcion', 'ASC');
                },
            ])
        ;
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults([
            'data_class' => Tnacional::class,
        ]);
    }
}
