<?php

namespace App\Form;

use App\Entity\Tcamion;
use App\Entity\Tdestino;
use App\Entity\Tempresa;
use App\Entity\Tinternacional;
use App\Entity\Torigen;
use App\Entity\Tpago;
use App\Entity\Tservicio;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\CheckboxType;
use Symfony\Component\Form\Extension\Core\Type\DateType;
use Symfony\Component\Form\Extension\Core\Type\NumberType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\Extension\Core\Type\FileType;
use Symfony\Component\Validator\Constraints\File;

use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

class TinternacionalpagaempresaType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder

            ->add('micdta',TextType::class,
                array('label'=>'No. de MIC/DTA',
                    'attr'=>array('class'=>'form-control', 'style' => 'margin-bottom:10px', 'maxlength'=>8, 'onkeypress'=>'return controlnum(event)')))

            ->add('fcobrofact',DateType::class, array(
                'widget'=>'single_text',
                'html5' => false,
                'input' => 'datetime',
                'label'=>'Fecha de Factura',
                'format'=>'dd/MM/yyyy',
                'attr'=> ['class'=>'form-control mydatepicker', 'style' => 'margin-bottom:5px','placeholder'=>'dd/mm/yyyy']))

            ->add('fpagofact',DateType::class, array(
                'widget'=>'single_text',
                'html5' => false,
                'input' => 'datetime',
                'label'=>'Fecha de Pago de Factura',
                'format'=>'dd/MM/yyyy',
                'attr'=> ['class'=>'form-control mydatepicker', 'style' => 'margin-bottom:5px','placeholder'=>'dd/mm/yyyy']))

            ->add('fac',TextType::class,
                array('label'=>'No. de Factura',
                    'attr'=>array('class'=>'form-control', 'style' => 'margin-bottom:10px', 'maxlength'=>8, 'onkeypress'=>'return controlnum(event)')))

            ->add('monto', NumberType::class,
                array('label'=>'Monto Bs.',
                    'attr'=>array('class'=>'form-control', 'style' => 'margin-bottom:10px', 'maxlength'=>8, 'onkeypress'=>'return controlnum(event)')))

            ->add('observacion',TextType::class,
                array('label'=>'Observaciones',
                    'attr'=>array('class'=>'form-control', 'style' => 'margin-bottom:10px', 'maxlength'=>1000)))

            ->add('idpago', EntityType::class, [
                'label' => 'Forma de Pago',
                'attr'=>array('class'=>'form-control', 'style' => 'margin-bottom:10px'),
                'class' => Tpago::class,
                'placeholder' => '---- Escoge la forma de Pago',
            ])

            ->add('idempresa', EntityType::class, [
                'label' => 'Empresa',
                'attr'=>array('class'=>'form-control', 'style' => 'margin-bottom:10px'),
                'class' => Tempresa::class,
                'placeholder' => '---- Escoge una empresa',
            ])

        ;
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults([
            'data_class' => Tinternacional::class,
        ]);
    }
}
