<?php

namespace App\Form;

use App\Entity\Tcamion;
use App\Entity\Tpertenencia;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\CheckboxType;
use Symfony\Component\Form\Extension\Core\Type\FileType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

class TcamionType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('placa', TextType::class, array(
                'label'=>'Placa',
                'attr'=>array('class'=>'form-control', 'style' => 'margin-bottom:10px', 'maxlength'=>10)))
            ->add('chasis', TextType::class, array(
                'label'=>'Chasis',
                'attr'=>array('class'=>'form-control', 'style' => 'margin-bottom:10px', 'maxlength'=>50)))
            ->add('marca', TextType::class, array(
                'label'=>'Marca',
                'attr'=>array('class'=>'form-control', 'style' => 'margin-bottom:10px', 'maxlength'=>50)))
            ->add('modelo',TextType::class,
                array('label'=>'Modelo',
                    'attr'=>array('class'=>'form-control', 'style' => 'margin-bottom:10px', 'maxlength'=>4, 'onkeypress'=>'return controlnum(event)')))
            ->add('foto',FileType::class, array(
                'required'=>false, 'attr'=>array('class'=>'form-control dropify', 'style' => 'margin-bottom:10px'),
                'label'=>'Foto', 'data_class'=>null))
            ->add('estado',CheckboxType::class,
                array('required'=>false, 'label'=>'Estado','attr'=>array('class'=>'form-control', 'style' => 'margin-bottom:0px')))
            ->add('idpertenencia', EntityType::class, [
                'label' => 'Propiedad',
                'attr'=>array('class'=>'form-control', 'style' => 'margin-bottom:10px'),
                'class'=>Tpertenencia::class,
                'placeholder' => '---- Escoge Pertenencia',
            ]);
        ;
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults([
            'data_class' => Tcamion::class,
        ]);
    }
}
