<?php

namespace App\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * Tmovimiento
 *
 * @ORM\Table(name="tmovimiento")
 * @ORM\Entity
 */
class Tmovimiento
{
    /**
     * @var int
     *
     * @ORM\Column(name="idmovimiento", type="smallint", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $idmovimiento;

    /**
     * @var string
     *
     * @ORM\Column(name="descripcion", type="string", length=50, nullable=false)
     */
    private $descripcion;

    public function getIdmovimiento(): ?int
    {
        return $this->idmovimiento;
    }

    public function getDescripcion(): ?string
    {
        return $this->descripcion;
    }

    public function setDescripcion(string $descripcion): self
    {
        $this->descripcion = $descripcion;

        return $this;
    }

    public function __toString()
    {
        return $this->getDescripcion();
    }
}
