<?php

namespace App\Controller;

use App\Entity\Trol;
use App\Entity\Tusuario;
use App\Form\Tusuario_transportistaType;
use App\Form\TusuarioType;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;

use Symfony\Component\HttpFoundation\File\UploadedFile;
use App\Models\DocumentAny;
use Symfony\Component\Security\Core\Encoder\UserPasswordEncoderInterface;

/**
 * @Route("/tusuario")
 */
class TusuarioController extends AbstractController
{
    private $passwordEncoder;

    public function __construct(UserPasswordEncoderInterface $passwordEncoder)
    {
        $this->passwordEncoder = $passwordEncoder;
    }

    /**
     * @Route("/", name="tusuario_index", methods={"GET"})
     */
    public function index(): Response
    {
        $filters = array(1, 2, 5);
        $User = $this->getUser();
        $em = $this->getDoctrine()->getManager();
        $RolUsuario = $em->getRepository( Trol::class )->findOneBy( [ 'idrol' => $User->getIdrol('idrol') ] );

        $tusuarios = $this->getDoctrine()
            ->getRepository(Tusuario::class)
            ->findBy(array('idrol' => $filters));

        $deleteFormAjax = $this->createCustomForm(':USER_ID', 'DELETE', 'tusuario_delete');

        if($RolUsuario->getIdrol('idrol') == 3 or $RolUsuario->getIdrol('idrol') == 4)
            return $this->render('default/index.html.twig', [
                'controller_name' => 'DefaultController',
            ]);
        else
            return $this->render('tusuario/index.html.twig', [
                'tusuarios' => $tusuarios,
                'delete_form_ajax' => $deleteFormAjax->createView()
            ]);
    }

    /**
     * @Route("/transportistas", name="tusuario_indextrans", methods={"GET"})
     */
    public function indextrans(): Response
    {
        $filters = array(3, 4);
        $User = $this->getUser();
        $em = $this->getDoctrine()->getManager();
        $RolUsuario = $em->getRepository( Trol::class )->findOneBy( [ 'idrol' => $User->getIdrol('idrol') ] );

        $tusuarios = $this->getDoctrine()
            ->getRepository(Tusuario::class)
            ->findBy(array('idrol' => $filters));

        $deleteFormAjax = $this->createCustomForm(':USER_ID', 'DELETE', 'tusuario_delete');

        return $this->render('tusuario/index_transportistas.html.twig', [
            'tusuarios' => $tusuarios,
            'delete_form_ajax' => $deleteFormAjax->createView()
        ]);
    }

    /**
     * @Route("/new", name="tusuario_new", methods={"GET","POST"})
     */
    public function new(Request $request, UserPasswordEncoderInterface $encoder): Response
    {
        $User = $this->getUser();

        $em = $this->getDoctrine()->getManager();
        $RolUsuario = $em->getRepository( Trol::class )->findOneBy( [ 'idrol' => $User->getIdrol('idrol') ] );

//		var_dump($RolUsuario->getIdrol()); exit();

        $tusuario = new Tusuario();
        $form = $this->createForm(TusuarioType::class, $tusuario, array ('usuario'=>$RolUsuario->getIdrol()));
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $miMensaje1='';

            if($form['plainPassword']->getData() <> '')
            {
    //            $image = $tusuario->getFoto();
                $image = $form['foto']->getData();

                $password = $form->get('plainPassword')->getData();

    //            $encoder = $this->container->get('security.password_encoder');
                $encoded = $this->passwordEncoder->encodePassword($tusuario, $password);
                $tusuario->setPassword($encoded);

                $em = $this->getDoctrine()->getManager();
                $tRoles = $em->getRepository(Trol::class)->findBy(array('idrol' => $form->get('idrol')->getData()));

                foreach($tRoles as $cod)
                {
    //					var_dump($cod->getRldescripcion()); exit();
                    $tusuario->setRoles(array($cod->getDescripcion()));
                }

                if(!$image) {
                    $tusuario->setFoto('usuariogenerico.jpg' );
                    $entityManager = $this->getDoctrine()->getManager();
                    $entityManager->persist($tusuario);
                    $entityManager->flush();

    //		        $this->get('session')->getFlashBag()->add('mensaje', 'Se creó el usuario exitósamente');
                    $this->addFlash('mensaje', 'Se creó el usuario exitósamente');
                    return $this->redirectToRoute('tusuario_index');
                }

                if(($image instanceof UploadedFile) && ($image->getError() == '0'))
                {
                    $originalName = $image->getClientOriginalName();
                    $name_array = explode('.',$originalName);
                    $file_type = $name_array[sizeof($name_array) - 1];
                    $valid_filetypes = array('jpg','jpeg','png','bmp');
                    if(in_array(strtolower($file_type), $valid_filetypes))
                    {
                        $document = new DocumentAny();
                        $document->setFile($image);

                        $document->setSubDirectory('usuarios');
                        $document->processFile();
                        $nombre=$document->getFilePersistencePath();

                        $tusuario->setFoto($nombre);

                        $entityManager = $this->getDoctrine()->getManager();
                        $entityManager->persist($tusuario);
                        $entityManager->flush();

                        $this->addFlash('mensaje', 'Se creó el usuario exitósamente');
                        return $this->redirectToRoute('tusuario_index');
                    }
                    else
                    {
                        $this->get('session')->getFlashBag()->add('mensaje',
                            'La extension del archivo no es la correcta');
    //                    return $this->redirect($this->generateUrl('tusuario_index'));
                        return $this->redirectToRoute('tusuario_index');
                    }
                }
                else
                {
                    $this->get('session')->getFlashBag()->add('mensaje',
                        'No ingreso el archivo o se produjo un error inesperado');
    //                return $this->redirect($this->generateUrl('tusuario_index'));
                    return $this->redirectToRoute('tusuario_index');
                }

            }
            else
            {
                if ( $form['plainPassword']->getData() == '' ) {
                    $miMensaje1 = 'Debe Colocar una Contraseña';
                }
                return $this->render('tusuario/new.html.twig', [
                    'tusuario' => $tusuario,
                    'form' => $form->createView(),
                    'mimensaje1' => $miMensaje1,
                ]);
            }
        }
        return $this->render('tusuario/new.html.twig', [
            'tusuario' => $tusuario,
            'form' => $form->createView(),
        ]);

    }


    /**
     * @Route("/newtrans", name="tusuario_transportista_new", methods={"GET","POST"})
     */
    public function newtransportista(Request $request, UserPasswordEncoderInterface $encoder): Response
    {
        $User = $this->getUser();

        $em = $this->getDoctrine()->getManager();
        $RolUsuario = $em->getRepository( Trol::class )->findOneBy( [ 'idrol' => $User->getIdrol('idrol') ] );

//		var_dump($RolUsuario->getIdrol()); exit();

        $tusuario = new Tusuario();
        $form = $this->createForm(Tusuario_transportistaType::class, $tusuario, array ('usuario'=>$RolUsuario->getIdrol()));
        $tusuario->setUsername('1234');
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
//            $image = $tusuario->getFoto();
            $image = $form['foto']->getData();

            $password = '1234';

//            $encoder = $this->container->get('security.password_encoder');
            $encoded = $this->passwordEncoder->encodePassword($tusuario, $password);
            $tusuario->setPassword($encoded);
            $tusuario->setUsername($tusuario->getCarnet());
            $tusuario->setIdrol($em->getRepository( Trol::class )->findBy( [ 'idrol' => 3] )[0] );

            $em = $this->getDoctrine()->getManager();
//            $tRoles = $em->getRepository(Trol::class)->findBy(array('idrol' => $form->get('idrol')->getData()));
            $tRoles = $em->getRepository(Trol::class)->findBy(array('idrol' => 3));

            foreach($tRoles as $cod)
            {
//					var_dump($cod->getRldescripcion()); exit();
                $tusuario->setRoles(array($cod->getDescripcion()));
            }

            if(!$image) {
                $tusuario->setFoto('usuariogenerico.jpg' );
                $entityManager = $this->getDoctrine()->getManager();
                $entityManager->persist($tusuario);
                $entityManager->flush();

//		        $this->get('session')->getFlashBag()->add('mensaje', 'Se creó el usuario exitósamente');
                $this->addFlash('mensaje', 'Se creó el transportista exitósamente');
                return $this->redirectToRoute('tusuario_indextrans');
            }

            if(($image instanceof UploadedFile) && ($image->getError() == '0'))
            {
                $originalName = $image->getClientOriginalName();
                $name_array = explode('.',$originalName);
                $file_type = $name_array[sizeof($name_array) - 1];
                $valid_filetypes = array('jpg','jpeg','png','bmp');
                if(in_array(strtolower($file_type), $valid_filetypes))
                {
                    $document = new DocumentAny();
                    $document->setFile($image);

                    $document->setSubDirectory('usuarios');
                    $document->processFile();
                    $nombre=$document->getFilePersistencePath();

                    $tusuario->setFoto($nombre);

                    $entityManager = $this->getDoctrine()->getManager();
                    $entityManager->persist($tusuario);
                    $entityManager->flush();

                    $this->addFlash('mensaje', 'Se creó el transportista exitósamente');
                    return $this->redirectToRoute('tusuario_indextrans');
                }
                else
                {
                    $this->get('session')->getFlashBag()->add('mensaje',
                        'La extension del archivo no es la correcta');
//                    return $this->redirect($this->generateUrl('tusuario_index'));
                    return $this->redirectToRoute('tusuario_indextrans');
                }
            }
            else
            {
                $this->get('session')->getFlashBag()->add('mensaje',
                    'No ingreso el archivo o se produjo un error inesperado');
//                return $this->redirect($this->generateUrl('tusuario_index'));
                return $this->redirectToRoute('tusuario_indextrans');
            }

        }

        return $this->render('tusuario/new_transportista.html.twig', [
            'tusuario' => $tusuario,
            'form' => $form->createView(),
        ]);
    }


    /**
     * @Route("/{idusuario}", name="tusuario_show", methods={"GET"})
     */
    public function show(Tusuario $tusuario): Response
    {
        return $this->render('tusuario/show.html.twig', [
            'tusuario' => $tusuario,
        ]);
    }


    /**
     * @Route("/{idusuario}/muestratrans", name="tusuario_transportista_show", methods={"GET"})
     */
    public function showtransportista(Tusuario $tusuario): Response
    {
        return $this->render('tusuario/show_transportista.html.twig', [
            'tusuario' => $tusuario,
        ]);
    }


    /**
     * @Route("/{idusuario}/edit", name="tusuario_edit", methods={"GET","POST"})
     */
    public function edit(Request $request, Tusuario $tusuario): Response
    {
        $imageEmpty = $tusuario->getFoto();
        $User = $this->getUser();

        $em = $this->getDoctrine()->getManager();
        $RolUsuario = $em->getRepository( Trol::class )->findOneBy( [ 'idrol' => $User->getIdrol('idrol') ] );

//		var_dump($RolUsuario->getIdrol()); exit();

        $form = $this->createForm(TusuarioType::class, $tusuario, array('usuario'=>$RolUsuario->getIdrol()));

        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $miMensaje1='';

            if($form['plainPassword']->getData() <> '') {
                $image = $form['foto']->getData();

                $em = $this->getDoctrine()->getManager();
                $tRoles = $em->getRepository(Trol::class)->findBy(array('idrol' => $tusuario->getIdrol()));

                foreach ($tRoles as $cod) {
                    $tusuario->setRoles(array($cod->getDescripcion()));
                }

                $password = $form->get('plainPassword')->getData();
                if (!empty($password)) {
//                $encoder = $this->container->get( 'security.password_encoder' );
                    $encoded = $this->passwordEncoder->encodePassword($tusuario, $password);
                    $tusuario->setPassword($encoded);

//                $encoded = $encoder->encodePassword( $tusuario, $password );
//                $tusuario->setPassword( $encoded );
                } else {
                    $id = $tusuario->getIdUsuario();
                    $recoverPass = $this->recoverPass($id);
                    $tusuario->setPassword($recoverPass[0]['password']);
                }

                if (!$image) {
                    $tusuario->setFoto($imageEmpty);
                    $this->getDoctrine()->getManager()->flush();

//			    $this->get('session')->getFlashBag()->add('mensaje', 'Se actualizó los datos del usuario exitósamente');
                    $this->addFlash('mensaje', 'Se actualizó los datos del usuario exitósamente');

                    if ($this->isGranted('ROLE_ADMINISTRADOR'))
                        return $this->redirectToRoute('tusuario_index');
                    else
                        return $this->redirectToRoute('homepage');

                } else {
                    if (($image instanceof UploadedFile) && ($image->getError() == '0')) {
                        $originalName = $image->getClientOriginalName();
                        $name_array = explode('.', $originalName);
                        $file_type = $name_array[sizeof($name_array) - 1];
                        $valid_filetypes = array('jpg', 'jpeg', 'bmp');
                        if (in_array(strtolower($file_type), $valid_filetypes)) {
                            $document = new DocumentAny();
                            $document->setFile($image);
                            // la siguiente fila es opcional si quisiera guardar en una carpeta adicional... solo es para ordenar
                            $document->setSubDirectory('usuarios');
                            $document->processFile();

                            $nombre = $document->getFilePersistencePath();
                            $tusuario->setFoto($nombre);

                            $this->getDoctrine()->getManager()->flush();

                            $this->addFlash('mensaje', 'Se actualizó los datos del usuario exitósamente');

                            if ($this->isGranted('ROLE_ADMINISTRADOR'))
                                return $this->redirect($this->generateUrl('tusuario_index'));
                            else
                                return $this->redirect($this->generateUrl('homepage'));

                        } else {
                            $this->get('session')->getFlashBag()->add('mensaje',
                                'La extension del archivo no es la correcta');

                            if ($this->isGranted('ROLE_ADMINISTRADOR'))
                                return $this->redirect($this->generateUrl('tusuario_index'));
                            else
                                return $this->redirect($this->generateUrl('homepage'));
                        }
                    } else {
                        $this->get('session')->getFlashBag()->add('mensaje',
                            'No ingreso el archivo o se produjo un error inesperado');

                        if ($this->isGranted('ROLE_ADMINISTRADOR'))
                            return $this->redirect($this->generateUrl('tusuario_index'));
                        else
                            return $this->redirect($this->generateUrl('homepage'));
                    }
                }
            }
            else
            {
                if ( $form['plainPassword']->getData() == '' ) {
                    $miMensaje1 = 'Debe Colocar una Contraseña';
                }
                return $this->render('tusuario/edit.html.twig', [
                    'tusuario' => $tusuario,
                    'form' => $form->createView(),
                    'mimensaje1' => $miMensaje1,
                ]);
            }
        }

        return $this->render('tusuario/edit.html.twig', [
            'tusuario' => $tusuario,
            'form' => $form->createView(),
        ]);
    }


    /**
     * @Route("/{idusuario}/edittrans", name="tusuario_transportista_edit", methods={"GET","POST"})
     */
    public function edittransportista(Request $request, Tusuario $tusuario): Response
    {
        $imageEmpty = $tusuario->getFoto();
        $User = $this->getUser();

        $em = $this->getDoctrine()->getManager();
        $RolUsuario = $em->getRepository( Trol::class )->findOneBy( [ 'idrol' => $User->getIdrol('idrol') ] );

//		var_dump($RolUsuario->getIdrol()); exit();

        $form = $this->createForm(Tusuario_transportistaType::class, $tusuario, array('usuario'=>$RolUsuario->getIdrol()));

        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $image = $form['foto']->getData();

//            $em = $this->getDoctrine()->getManager();
//            $tRoles = $em->getRepository(Trol::class)->findBy(array('idrol' => $tusuario->getIdrol()));
//
//            foreach($tRoles as $cod)
//            {
//                $tusuario->setRoles(array($cod->getDescripcion()));
//            }

//            $password = $form->get('plainPassword')->getData();
//            if(!empty($password)) {
////                $encoder = $this->container->get( 'security.password_encoder' );
//                $encoded = $this->passwordEncoder->encodePassword($tusuario, $password);
//                $tusuario->setPassword($encoded);
//
////                $encoded = $encoder->encodePassword( $tusuario, $password );
////                $tusuario->setPassword( $encoded );
//            }
//            else {
//                $id = $tusuario->getIdUsuario();
//                $recoverPass = $this->recoverPass($id);
//                $tusuario->setPassword($recoverPass[0]['password']);
//            }

            if (!$image)
            {
                $tusuario->setFoto($imageEmpty);
                $this->getDoctrine()->getManager()->flush();

//			    $this->get('session')->getFlashBag()->add('mensaje', 'Se actualizó los datos del usuario exitósamente');
                $this->addFlash('mensaje', 'Se actualizó los datos del transportista exitósamente');

                return $this->redirectToRoute('tusuario_indextrans');

            }else
            {
                if(($image instanceof UploadedFile) && ($image->getError() == '0'))
                {
                    $originalName = $image->getClientOriginalName();
                    $name_array = explode('.',$originalName);
                    $file_type = $name_array[sizeof($name_array) - 1];
                    $valid_filetypes = array('jpg','jpeg','bmp');
                    if(in_array(strtolower($file_type), $valid_filetypes))
                    {
                        $document = new DocumentAny();
                        $document->setFile($image);
                        // la siguiente fila es opcional si quisiera guardar en una carpeta adicional... solo es para ordenar
                        $document->setSubDirectory('usuarios');
                        $document->processFile();

                        $nombre=$document->getFilePersistencePath();
                        $tusuario->setFoto($nombre);

                        $this->getDoctrine()->getManager()->flush();

                        $this->addFlash('mensaje', 'Se actualizó los datos del transportista exitósamente');
                        return $this->redirect($this->generateUrl('tusuario_indextrans'));

                    }else
                    {
                        $this->get('session')->getFlashBag()->add('mensaje',
                            'La extension del archivo no es la correcta');

                        return $this->redirect($this->generateUrl('tusuario_indextrans'));
                    }
                }else
                {
                    $this->get('session')->getFlashBag()->add('mensaje',
                        'No ingreso el archivo o se produjo un error inesperado');

                    return $this->redirect($this->generateUrl('tusuario_indextrans'));
                }
            }

//            return $this->redirectToRoute('tusuario_index');
        }

        return $this->render('tusuario/edit_transportista.html.twig', [
            'tusuario' => $tusuario,
            'form' => $form->createView(),
        ]);
    }

//    /**
//     * @Route("/{idusuario}", name="tusuario_delete", methods={"DELETE"})
//     */
//    public function delete(Request $request, Tusuario $tusuario): Response
//    {
//        if ($this->isCsrfTokenValid('delete'.$tusuario->getIdusuario(), $request->request->get('_token'))) {
//            $entityManager = $this->getDoctrine()->getManager();
//            $entityManager->remove($tusuario);
//            $entityManager->flush();
//        }
//
//        return $this->redirectToRoute('tusuario_index');
//    }









    private function createCustomForm($id, $method, $route)
    {
        return $this->createFormBuilder()
            ->setAction($this->generateUrl($route, array('id'=>$id)))
            ->setMethod($method)
            ->getForm();
    }


    private function deleteUser($role, $em, $tUsuario)
    {
        if($role <> 'ROLE_SUPER')
        {
            $em->remove($tUsuario);
            $em->flush();

            $message = 'El usuario ha sido eliminado exitósamente';
            //$this->get('session')->getFlashBag()->add('message',
            //                    'Se eliminó el registro exitosamente');
            $removed = 1;
            $alert = 'mensaje';
        }
        else
        {
            $message = 'El SUPER Usuario No puede ser  eliminado';
            $removed = 0;
            $alert = 'error';
        }

        return array('removed'=>$removed, 'message'=>$message, 'alert'=>$alert);
    }


    /**
     * @Route("/delete/{id}", name="tusuario_delete")
     */
    public function deleteAction(Request $request, TUsuario $tUsuario)
    {
        $form = $this->createCustomForm($tUsuario->getIdUsuario(), 'DELETE', 'tusuario_delete');
        $form->handleRequest($request);
        $em = $this->getDoctrine()->getManager();

        if ($form->isSubmitted() && $form->isValid()) {

            if($request->isXMLHttpRequest())
            {
                $res = $this->deleteUser($tUsuario->getRoles(), $em, $tUsuario);

                return new Response(
                    json_encode(array('removed'=>$res['removed'], 'message'=>$res['message'], )),
                    200,
                    array('Content-Type'=>'application/json')
                );
            }

            $res = $this->deleteUser($tUsuario->getRoles(), $em, $tUsuario);

            $this->addFlash($res['alert'], $res['message']);

            return $this->redirectToRoute('tusuario_index');
        }
    }


}
