<?php

namespace App\Controller;

use App\Entity\Tfactnal;
use App\Entity\Tmovimiento;
use App\Entity\Tnacional;
use App\Entity\Tregnal;
use App\Entity\Tusuario;
use App\Form\Tregnal_adjuntaType;
use App\Form\Tregnal_despachoType;
use App\Form\Tregnal_entregaType;
use App\Form\Tregnal_pagoType;
use App\Form\TregnalType;
//use Models\DocumentAny;
use App\Models\DocumentAny;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\File\UploadedFile;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;

/**
 * @Route("/tregnal")
 */
class TregnalController extends AbstractController
{
    /**
     * @Route("/rn/{idnacional}", name="tregnal_index", methods={"GET"})
     */
    public function index($idnacional): Response
    {


        $em = $this->getDoctrine()->getManager();
        $tregnals = $em->getRepository('App:Tusuario')->getRegNacional($idnacional);

        $tNacional = $this->getDoctrine()
            ->getRepository(Tnacional::class)->findOneBy(array('idnacional'=>$idnacional));


        date_default_timezone_set('America/La_Paz');
        $indice = 0;
        $habilitaEdicion = array();

        foreach ($tregnals as $tNal) {
            $fechaComprobar = strtotime($tNal['Hoy']);
            $fecha1 = strtotime($tNal['fecharegistro']->format('Y-m-d H:i:s'));
            $fecha2  = strtotime ( '+20 minute' , strtotime($tNal['fecharegistro']->format('Y-m-d H:i:s')) ) ;

            if ($fechaComprobar >= $fecha1 and $fechaComprobar <= $fecha2)
                $habilitaEdicion[$indice] = true;
            else
                $habilitaEdicion[$indice] = false;

            $indice = $indice + 1;
        }


        $deleteFormAjax = $this->createCustomForm(':USER_ID', 'DELETE', 'tregnal_delete');

        return $this->render('tregnal/index.html.twig', [
            'tregnals' => $tregnals,
            'idnacional'=>$idnacional,
            'tNacional'=>$tNacional,
            'habilitaEdicion' => $habilitaEdicion,
            'delete_form_ajax' => $deleteFormAjax->createView()
        ]);
    }

    /**
     * @Route("/new/{idnacional}", name="tregnal_new", methods={"GET","POST"})
     */
    public function new(Request $request, $idnacional): Response
    {
        $usuario = $this->getUser();

        $tregnal = new Tregnal();

        $tregnal->setMontopagar(0);
        $tregnal->setDescuento(0);
        $tregnal->setMontopagado(0);

        $form = $this->createForm(TregnalType::class, $tregnal);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            date_default_timezone_set('America/La_Paz');
            $fecha = new \DateTime("now");

            $em = $this->getDoctrine()->getManager();
            $tregnal->setIdnacional($em->getRepository( Tnacional::class )->findBy( [ 'idnacional' => $idnacional] )[0] );
            $tregnal->setIdmovimiento($em->getRepository( Tmovimiento::class )->findBy( [ 'idmovimiento' => 1] )[0] );
            $tregnal->setAuditoria($fecha->format('d-m-Y H:i') . '; '. $usuario->getUsername(). '; Nuevo Chasis Nal. ');

            $tregnal->setFechasalida(date_create_from_format('d-m-Y', '01-01-1980'));
            $tregnal->setFechaentrega(date_create_from_format('d-m-Y', '01-01-1980'));
            $tregnal->setFechapago(date_create_from_format('d-m-Y', '01-01-1980'));
            $tregnal->setFactura(0);
            $tregnal->setArchivo('docgenerico.png');
            $tregnal->setFecharegistro($fecha);


            $entityManager = $this->getDoctrine()->getManager();
            $entityManager->persist($tregnal);
            $entityManager->flush();

            $this->addFlash('mensaje', 'Se creó la instancia del chasis del vehículo exitósamente');
            return $this->redirectToRoute('tregnal_index',[
                'idnacional' => $idnacional,
                ]);
        }

        return $this->render('tregnal/new.html.twig', [
            'tregnal' => $tregnal,
            'idnacional' => $idnacional,
            'form' => $form->createView(),
        ]);
    }

    /**
     * @Route("/{idregnal}", name="tregnal_show", methods={"GET"})
     */
    public function show(Tregnal $tregnal): Response
    {
        return $this->render('tregnal/show.html.twig', [
            'tregnal' => $tregnal,
        ]);
    }

    /**
     * @Route("/{idregnal}/{idnacional}/edit", name="tregnal_edit", methods={"GET","POST"})
     */
    public function edit(Request $request, Tregnal $tregnal, $idnacional): Response
    {
        $form = $this->createForm(TregnalType::class, $tregnal);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $this->getDoctrine()->getManager()->flush();

            $this->addFlash('mensaje', 'Se editó la instancia del chasis del vehículo exitósamente');
            return $this->redirectToRoute('tregnal_index', [
                'idnacional' => $idnacional,
            ]);
        }

        return $this->render('tregnal/edit.html.twig', [
            'tregnal' => $tregnal,
            'idnacional' => $idnacional,
            'form' => $form->createView(),
        ]);
    }


    /**
     * @Route("/despachar/{idregnal}/{idnacional}", name="new_despacho", methods={"GET","POST"})
     */
    public function new_despacho(Request $request, Tregnal $tregnal, $idnacional): Response
    {
        $miObservacion = $tregnal->getObservaciones() . ' | ';
        $tregnal->setObservaciones('');

        if ($tregnal->getFechasalida()->format('Y') == '1980')
            $tregnal->setFechasalida(new \DateTime("now"));

        $form = $this->createForm( Tregnal_despachoType::class, $tregnal);

//        var_dump($miObservacion); exit();

        $form->handleRequest($request);

        $usuario = $this->getUser();

        if ($form->isSubmitted() && $form->isValid()) {
//        if($request->isXmlHttpRequest()) {
            date_default_timezone_set('America/La_Paz');
            $fecha = new \DateTime("now");

            $em = $this->getDoctrine()->getManager();

//            $tregnal->setFechasalida($fecha);
            $tregnal->setIdmovimiento($em->getRepository( Tmovimiento::class )->findBy( ['idmovimiento' => 2] )[0] );
            $tregnal->setAuditoria($tregnal->getAuditoria() . '|' . $fecha->format('d-m-Y H:i') . '; '. $usuario->getUsername(). '; Nuevo Despacho Nal. ');
            $tregnal->setObservaciones($miObservacion . $tregnal->getObservaciones());

            $em = $this->getDoctrine()->getManager();
            $em->persist($tregnal);
            $em->flush();

            $this->addFlash('mensaje', 'Se asignó el transportista al vehículo exitósamente');
            return $this->redirectToRoute('tregnal_index', [
                'idnacional' => $idnacional,
            ]);
        }

        return $this->render('tregnal/salida_modal.html.twig', [
            'tregnal' => $tregnal,
            'idnacional' => $idnacional,
            'form' => $form->createView(),
        ]);
    }

    /**
     * @Route("/entregar/{idregnal}/{idnacional}", name="new_entrega", methods={"GET","POST"})
     */
    public function new_entrega(Request $request, Tregnal $tregnal, $idnacional): Response
    {
        $miObservacion = $tregnal->getObservaciones() . ' | ';
        $tregnal->setObservaciones('');
        if ($tregnal->getFechaentrega()->format('Y') == '1980')
            $tregnal->setFechaentrega(new \DateTime("now"));

        $form2 = $this->createForm(Tregnal_entregaType::class, $tregnal);
        $form2->handleRequest($request);

        $usuario = $this->getUser();

        if ($form2->isSubmitted() && $form2->isValid()) {
            date_default_timezone_set('America/La_Paz');
            $fecha = new \DateTime("now");

            $em = $this->getDoctrine()->getManager();

//            $tregnal->setFechaentrega($fecha);
            $tregnal->setIdmovimiento($em->getRepository( Tmovimiento::class )->findBy( ['idmovimiento' => 3] )[0] );
            $tregnal->setAuditoria($tregnal->getAuditoria() . '|' . $fecha->format('d-m-Y H:i') . '; '. $usuario->getUsername(). '; Nueva Entrega Nal. ');
            $tregnal->setObservaciones($miObservacion . $tregnal->getObservaciones());

            $em = $this->getDoctrine()->getManager();
            $em->persist($tregnal);
            $em->flush();

            $this->addFlash('mensaje', 'Se entregó el vehículo exitósamente');
            return $this->redirectToRoute('tregnal_index', [
                'idnacional' => $idnacional,
            ]);
        }

        return $this->render('tregnal/entrega_modal.html.twig', [
            'tregnal' => $tregnal,
            'idnacional' => $idnacional,
            'form2' => $form2->createView(),
        ]);
    }



    /**
     * @Route("/pagar/{idregnal}/{idnacional}", name="new_pago", methods={"GET","POST"})
     */
    public function new_pago(Request $request, Tregnal $tregnal, $idnacional): Response
    {
        if ($tregnal->getFechapago()->format('Y') == '1980')
            $tregnal->setFechapago(new \DateTime("now"));

        $form3 = $this->createForm(  Tregnal_pagoType::class, $tregnal);
        $form3->handleRequest($request);

        $usuario = $this->getUser();

        $em = $this->getDoctrine()->getManager();
        $tTransportista= $em->getRepository( Tusuario::class )->findBy( ['idusuario' => $tregnal->getIdusuario()] );

        if ($form3->isSubmitted() && $form3->isValid()) {
            $miMensaje1='';
            $miMensaje2='';
            $miMensaje3='';

            if($form3['idpago']->getData() <> '' and $form3['observaciondesc']->getData() <> '') {

                date_default_timezone_set('America/La_Paz');
                $fecha = new \DateTime("now");

//                $tregnal->setFechapago($fecha);
                $tregnal->setIdmovimiento($em->getRepository(Tmovimiento::class)->findBy(['idmovimiento' => 4])[0]);
                $tregnal->setAuditoria($tregnal->getAuditoria() . '|' . $fecha->format('d-m-Y H:i') . '; ' . $usuario->getUsername() . '; Nuevo Pago Nal. ');
                $tregnal->setMontopagado($tregnal->getMontopagar() - $tregnal->getDescuento());

                $em = $this->getDoctrine()->getManager();
                $em->persist($tregnal);
                $em->flush();

                $this->addFlash('mensaje', 'Se realizó el pagó al transportista exitósamente');
                return $this->redirectToRoute('tregnal_index', [
                    'idnacional' => $idnacional,
                ]);
            }
            else
            {
                if ( $form3['idpago']->getData() == '' ) {
                    $miMensaje1 = 'Debe Colocar una forma de pago al transportista';
                    return $this->render('tregnal/pago_modal.html.twig', [
                        'tregnal' => $tregnal,
                        'idnacional' => $idnacional,
                        'tTransportista' => $tTransportista[0],
                        'mimensaje1' => $miMensaje1,
                        'form3' => $form3->createView(),
                    ]);
                }

//                if ( $form3['descuento']->getData() == '' ) {
//                    $miMensaje2 = 'El descuento no puede estar vacío';
//                    return $this->render('tregnal/pago_modal.html.twig', [
//                        'tregnal' => $tregnal,
//                        'idnacional' => $idnacional,
//                        'tTransportista' => $tTransportista[0],
//                        'mimensaje2' => $miMensaje2,
//                        'form3' => $form3->createView(),
//                    ]);
//                }

                if ( $form3['observaciondesc']->getData() == '' ) {
                    $miMensaje3 = 'Debe Colocar algún detalle del pago o descuento';
                    return $this->render('tregnal/pago_modal.html.twig', [
                        'tregnal' => $tregnal,
                        'idnacional' => $idnacional,
                        'tTransportista' => $tTransportista[0],
                        'mimensaje3' => $miMensaje3,
                        'form3' => $form3->createView(),
                    ]);
                }
            }
        }

        if($tTransportista)
            return $this->render('tregnal/pago_modal.html.twig', [
                'tregnal' => $tregnal,
                'idnacional' => $idnacional,
                'tTransportista' => $tTransportista[0],
                'form3' => $form3->createView(),
            ]);
        else
            return $this->render('tregnal/pago_modal.html.twig', [
                'tregnal' => $tregnal,
                'idnacional' => $idnacional,
                'tTransportista' => NULL,
                'form3' => $form3->createView(),
            ]);
    }

    /**
     * @Route("/adjuntar/{idregnal}/{idnacional}", name="new_adjuntar", methods={"GET","POST"})
     */
    public function new_adjuntar(Request $request, Tregnal $tregnal, $idnacional): Response
    {
        $miObservacion = $tregnal->getObservaciones() . ' | ';
        $tregnal->setObservaciones('');
        $imageEmpty = $tregnal->getArchivo();

        $em = $this->getDoctrine()->getManager();
        $misFacturas = $em->getRepository( Tfactnal::class )->findBy( [ 'idnacional' => $idnacional] ) ;


        $form3 = $this->createForm(  Tregnal_adjuntaType::class, $tregnal, array('misFacturas'=>$misFacturas));
        $form3->handleRequest($request);

        $usuario = $this->getUser();

        if ($form3->isSubmitted() && $form3->isValid()) {
            date_default_timezone_set('America/La_Paz');
            $fecha = new \DateTime("now");

            $tregnal->setAuditoria($tregnal->getAuditoria() . '|' . $fecha->format('d-m-Y H:i') . '; '. $usuario->getUsername(). '; Adj. Fact/Doc Nal. ');
            $tregnal->setObservaciones($miObservacion . $tregnal->getObservaciones());

            $image = $request->files->get('miArchivo');

//            $image = $form3->get('archivo')->getData();
//            $image = $form3['archivo']->getData();

            if (!$image)
            {
                $tregnal->setArchivo($imageEmpty);
                $this->getDoctrine()->getManager()->flush();

                $this->addFlash('mensaje', 'Se actualizó el registro exitósamente');
                return $this->redirectToRoute('tregnal_index', ['idnacional' => $idnacional]);
            }else
            {
                if(($image instanceof UploadedFile) && ($image->getError() == '0'))
                {
                    $originalName = $image->getClientOriginalName();
                    $name_array = explode('.',$originalName);
                    $file_type = $name_array[sizeof($name_array) - 1];
                    $valid_filetypes = array('pdf', 'PDF');
                    if(in_array(strtolower($file_type), $valid_filetypes))
                    {
                        $document = new DocumentAny();
                        $document->setFile($image);
                        // la siguiente fila es opcional si quisiera guardar en una carpeta adicional... solo es para ordenar
                        $document->setSubDirectory('nacional');
                        $document->processFile();

                        $nombre=$document->getFilePersistencePath();
                        $tregnal->setArchivo($nombre);

                        $this->getDoctrine()->getManager()->flush();

                        $this->addFlash('mensaje', 'Se actualizó el registro exitósamente');
                        return $this->redirectToRoute('tregnal_index', ['idnacional' => $idnacional]);

                    }else
                    {
                        $this->get('session')->getFlashBag()->add('mensaje',
                            'La extension del archivo no es la correcta');
                        return $this->redirectToRoute('tregnal_index', ['idnacional' => $idnacional]);
                    }
                }else
                {
                    $this->get('session')->getFlashBag()->add('mensaje',
                        'No ingreso el archivo o se produjo un error inesperado');
                    return $this->redirectToRoute('tregnal_index', ['idnacional' => $idnacional]);
                }
            }

//            $em = $this->getDoctrine()->getManager();
//            $em->persist($tregnal);
//            $em->flush();

//            return $this->redirectToRoute('tregnal_index', ['idnacional' => $idnacional]);
        }

        return $this->render('tregnal/adjunta_modal.html.twig', [
            'tregnal' => $tregnal,
            'idnacional' => $idnacional,
            'form4' => $form3->createView(),
        ]);
    }


//    /**
//     * @Route("/{idregnal}", name="tregnal_delete", methods={"DELETE"})
//     */
//    public function delete(Request $request, Tregnal $tregnal): Response
//    {
//        if ($this->isCsrfTokenValid('delete'.$tregnal->getIdregnal(), $request->request->get('_token'))) {
//            $entityManager = $this->getDoctrine()->getManager();
//            $entityManager->remove($tregnal);
//            $entityManager->flush();
//        }
//
//        return $this->redirectToRoute('tregnal_index');
//    }


    private function createCustomForm($id, $method, $route)
    {
        return $this->createFormBuilder()
            ->setAction($this->generateUrl($route, array('id'=>$id)))
            ->setMethod($method)
            ->getForm();
    }


    private function deleteRegistro($em, $tRegnal)
    {
        $em->remove($tRegnal);
        $em->flush();

        $message = 'El registro del vehículo asignado ha sido eliminado exitósamente';
        //$this->get('session')->getFlashBag()->add('message', 'Se eliminó el registro exitosamente');
        $removed = 1;
        $alert = 'mensaje';

        return array('removed'=>$removed, 'message'=>$message, 'alert'=>$alert);
    }


    /**
     * @Route("/delete/{id}", name="tregnal_delete")
     */
    public function deleteAction(Request $request, Tregnal $tRegnal)
    {
        $form = $this->createCustomForm($tRegnal->getIdregnal(), 'DELETE', 'tregnal_delete');
        $form->handleRequest($request);
        $em = $this->getDoctrine()->getManager();

        if ($form->isSubmitted() && $form->isValid()) {

            if($request->isXMLHttpRequest())
            {
                $res = $this->deleteRegistro($em, $tRegnal);

                return new Response(
                    json_encode(array('removed'=>$res['removed'], 'message'=>$res['message'], )),
                    200,
                    array('Content-Type'=>'application/json')
                );
            }

            $res = $this->deleteRegistro($em, $tRegnal);

            $this->addFlash($res['alert'], $res['message']);

            return $this->redirectToRoute('tregnal_index');
        }
    }

}
