<?php

namespace App\Controller;

use App\Entity\Testado;
use App\Entity\Tinternacional;
use App\Entity\Tusuario;
use App\Form\TinternacionalentregaType;
use App\Form\TinternacionalpagaempresaType;
use App\Form\TinternacionalsalidaType;
use App\Form\TinternacionalType;
use App\Models\DocumentAny;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\File\UploadedFile;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;

/**
 * @Route("/tinternacional")
 */
class TinternacionalController extends AbstractController
{
    /**
     * @Route("/", name="tinternacional_index", methods={"GET"})
     */
    public function index(): Response
    {
        $tinternacionals = $this->getDoctrine()
            ->getRepository(Tinternacional::class)
            ->findAll();

        $deleteFormAjax = $this->createCustomForm(':USER_ID', 'DELETE', 'tinternacional_delete');
        
        return $this->render('tinternacional/index.html.twig', [
            'tinternacionals' => $tinternacionals,
            'delete_form_ajax' => $deleteFormAjax->createView()
        ]);
    }

    /**
     * @Route("/new", name="tinternacional_new", methods={"GET","POST"})
     */
    public function new(Request $request): Response
    {
        $usuario = $this->getUser();
        $tinternacional = new Tinternacional();
        $form = $this->createForm(TinternacionalsalidaType::class, $tinternacional);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $em = $this->getDoctrine()->getManager();
//            var_dump($em->getRepository( Testado::class )->findBy( [ 'idestado' => 1] )[0]); exit();
            $tinternacional->setIdestado($em->getRepository( Testado::class )->findBy( [ 'idestado' => 5] )[0] );

            date_default_timezone_set('America/La_Paz');
            $fecha = new \DateTime("now");

            $tinternacional->setAuditoria($fecha->format('d-m-Y H:i') . '; '. $usuario->getUsername(). '; Nuevo Trans. Internacional. ');
//            $tinternacional->setFechasalida($fecha);

            $tinternacional->setFechaentrega(date_create_from_format('d-m-Y', '01-01-1980'));
            $tinternacional->setFcobrofact(date_create_from_format('d-m-Y', '01-01-1980'));
            $tinternacional->setFpagofact(date_create_from_format('d-m-Y', '01-01-1980'));
            $tinternacional->setFac(0);
            $tinternacional->setMonto(0);
            $tinternacional->setDescuento(0);
            $tinternacional->setArchivo('docgenerico.png');
            $tinternacional->setIdusuario($em->getRepository( Tusuario::class )->findBy( ['idusuario' => $usuario->getIdusuario()] )[0] );

            $entityManager = $this->getDoctrine()->getManager();
            $entityManager->persist($tinternacional);
            $entityManager->flush();

            $this->addFlash('mensaje', 'Se creó el registro del Transporte Internacional corréctamente');
            return $this->redirectToRoute('tinternacional_index');
        }

        return $this->render('tinternacional/new.html.twig', [
            'tinternacional' => $tinternacional,
            'form' => $form->createView(),
        ]);
    }


    /**
     * @Route("/entregaint/{idinternacional}", name="new_entregaint", methods={"GET","POST"})
     */
    public function new_entregaint(Request $request, Tinternacional $tInternacional, $idinternacional): Response
    {
        $miObservacion = $tInternacional->getObservacion() . ' | ';
        $tInternacional->setObservacion('');

        if ($tInternacional->getFechaentrega()->format('Y') == '1980')
            $tInternacional->setFechaentrega(new \DateTime("now"));
        if ($tInternacional->getFcobrofact()->format('Y') == '1980')
            $tInternacional->setFcobrofact(new \DateTime("now"));

        $imageEmpty = $tInternacional->getArchivo();

        $form2 = $this->createForm(  TinternacionalentregaType::class, $tInternacional);
        $form2->handleRequest($request);

        $usuario = $this->getUser();

        if ($form2->isSubmitted() && $form2->isValid()) {
            $em = $this->getDoctrine()->getManager();
            date_default_timezone_set('America/La_Paz');
            $fecha = new \DateTime("now");

//            $tInternacional->setFechaentrega($fecha);
            $tInternacional->setIdestado($em->getRepository( Testado::class )->findBy( [ 'idestado' => 6] )[0] );
            $tInternacional->setAuditoria($tInternacional->getAuditoria() . '|' . $fecha->format('d-m-Y H:i') . '; '. $usuario->getUsername(). '; Nueva Entrega Internacional. ');
            $tInternacional->setObservacion($miObservacion . $tInternacional->getObservacion());

            $image = $request->files->get('miArchivo');

            if (!$image)
            {
                $tInternacional->setArchivo($imageEmpty);
                $this->getDoctrine()->getManager()->flush();

                $this->addFlash('mensaje', 'Se entregó los vehículos exitósamente');
                return $this->redirectToRoute('tinternacional_index');
            }else
            {
                if(($image instanceof UploadedFile) && ($image->getError() == '0'))
                {
                    $originalName = $image->getClientOriginalName();
                    $name_array = explode('.',$originalName);
                    $file_type = $name_array[sizeof($name_array) - 1];
                    $valid_filetypes = array('pdf', 'PDF');
                    if(in_array(strtolower($file_type), $valid_filetypes))
                    {
                        $document = new DocumentAny();
                        $document->setFile($image);
                        // la siguiente fila es opcional si quisiera guardar en una carpeta adicional... solo es para ordenar
                        $document->setSubDirectory('internacional');
                        $document->processFile();

                        $nombre=$document->getFilePersistencePath();
                        $tInternacional->setArchivo($nombre);

                        $this->getDoctrine()->getManager()->flush();

                        $this->addFlash('mensaje', 'Se entregó los vehículos exitósamente');
                        return $this->redirectToRoute('tinternacional_index');
                    }else
                    {
                        $this->get('session')->getFlashBag()->add('mensaje',
                            'La extension del archivo no es la correcta');
                        return $this->redirectToRoute('tinternacional_index');
                    }
                }else
                {
                    $this->get('session')->getFlashBag()->add('mensaje',
                        'No ingreso el archivo o se produjo un error inesperado');
                    return $this->redirectToRoute('tinternacional_index');
                }
            }

//            $em = $this->getDoctrine()->getManager();
//            $em->persist($tInternacional);
//            $em->flush();

        }

        return $this->render('tinternacional/entrega_modal.html.twig', [
            'tinternacional' => $tInternacional,
            'idinternacional' => $idinternacional,
            'form2' => $form2->createView(),
        ]);
    }


    /**
     * @Route("/pagaeint/{idinternacional}", name="new_paga_emp_int", methods={"GET","POST"})
     */
    public function new_paga_emp_int(Request $request, Tinternacional $tInternacional, $idinternacional): Response
    {
        $miObservacion = $tInternacional->getObservacion() . ' | ';
        $tInternacional->setObservacion('');

        if ($tInternacional->getFpagofact()->format('Y') == '1980')
            $tInternacional->setFpagofact(new \DateTime("now"));

        $form3 = $this->createForm(  TinternacionalpagaempresaType::class, $tInternacional);
        $form3->handleRequest($request);

        $usuario = $this->getUser();

        $em = $this->getDoctrine()->getManager();
        $tTransportista= $em->getRepository( Tusuario::class )->findBy( ['idusuario' => $tInternacional->getIdusuario()] );

        if ($form3->isSubmitted() && $form3->isValid()) {
            $miMensaje1='';

            if($form3['idpago']->getData() <> '') {

                date_default_timezone_set('America/La_Paz');
                $fecha = new \DateTime("now");

                $tInternacional->setIdestado($em->getRepository( Testado::class )->findBy( [ 'idestado' => 7] )[0] );
                $tInternacional->setAuditoria($tInternacional->getAuditoria() . '|' . $fecha->format('d-m-Y H:i') . '; ' . $usuario->getUsername() . '; Pago Empresa Internacional. ');
                $tInternacional->setObservacion($miObservacion . $tInternacional->getObservacion());

                $em = $this->getDoctrine()->getManager();
                $em->persist($tInternacional);
                $em->flush();

                $this->addFlash('mensaje', 'Se realizó el pagó al Transporte Internacional exitósamente');
                return $this->redirectToRoute('tinternacional_index');
            }
            else
            {
                if ( $form3['idpago']->getData() == '' ) {
                    $miMensaje1 = 'Debe Colocar una forma de pago al Transporte Internacional';
                    return $this->render('tinternacional/pagaempresa_modal.html.twig', [
                        'tinternacional' => $tInternacional,
                        'idinternacional' => $idinternacional,
                        'mimensaje1' => $miMensaje1,
                        'form3' => $form3->createView(),
                    ]);
                }
            }
        }

        return $this->render('tinternacional/pagaempresa_modal.html.twig', [
            'tinternacional' => $tInternacional,
            'idinternacional' => $idinternacional,
            'form3' => $form3->createView(),
        ]);
    }
    
    
    
    /**
     * @Route("/{idinternacional}", name="tinternacional_show", methods={"GET"})
     */
    public function show(Tinternacional $tinternacional): Response
    {
        return $this->render('tinternacional/show.html.twig', [
            'tinternacional' => $tinternacional,
        ]);
    }

    /**
     * @Route("/{idinternacional}/edit", name="tinternacional_edit", methods={"GET","POST"})
     */
    public function edit(Request $request, Tinternacional $tinternacional): Response
    {
        $miObservacion = $tinternacional->getObservacion() . ' | ';
        $tinternacional->setObservacion('');

        $usuario = $this->getUser();

        $form = $this->createForm(TinternacionalsalidaType::class, $tinternacional);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            date_default_timezone_set('America/La_Paz');
            $fecha = new \DateTime("now");

            $tinternacional->setObservacion($miObservacion . $tinternacional->getObservacion());
            $tinternacional->setAuditoria($fecha->format('d-m-Y H:i') . '; '. $usuario->getUsername(). '; Edición Trans. Internacional. ');

            $this->getDoctrine()->getManager()->flush();

            $this->addFlash('mensaje', 'Se realizó la edición del Transporte Internacional exitósamente');
            return $this->redirectToRoute('tinternacional_index');
        }

        return $this->render('tinternacional/edit.html.twig', [
            'tinternacional' => $tinternacional,
            'form' => $form->createView(),
        ]);
    }

//    /**
//     * @Route("/{idinternacional}", name="tinternacional_delete", methods={"DELETE"})
//     */
//    public function delete(Request $request, Tinternacional $tinternacional): Response
//    {
//        if ($this->isCsrfTokenValid('delete'.$tinternacional->getIdinternacional(), $request->request->get('_token'))) {
//            $entityManager = $this->getDoctrine()->getManager();
//            $entityManager->remove($tinternacional);
//            $entityManager->flush();
//        }
//
//        return $this->redirectToRoute('tinternacional_index');
//    }


    private function createCustomForm($id, $method, $route)
    {
        return $this->createFormBuilder()
            ->setAction($this->generateUrl($route, array('id'=>$id)))
            ->setMethod($method)
            ->getForm();
    }


    private function deleteRegistro($em, $tInternacional)
    {
        $em->remove($tInternacional);
        $em->flush();

        $message = 'El registro del Transporte Internacional ha sido eliminado exitósamente';
        //$this->get('session')->getFlashBag()->add('message', 'Se eliminó el registro exitosamente');
        $removed = 1;
        $alert = 'mensaje';

        return array('removed'=>$removed, 'message'=>$message, 'alert'=>$alert);
    }


    /**
     * @Route("/delete/{id}", name="tinternacional_delete")
     */
    public function deleteAction(Request $request, Tinternacional $tInternacional)
    {
        $form = $this->createCustomForm($tInternacional->getIdinternacional(), 'DELETE', 'tinternacional_delete');
        $form->handleRequest($request);
        $em = $this->getDoctrine()->getManager();

        if ($form->isSubmitted() && $form->isValid()) {

            if($request->isXMLHttpRequest())
            {
                $res = $this->deleteRegistro($em, $tInternacional);

                return new Response(
                    json_encode(array('removed'=>$res['removed'], 'message'=>$res['message'], )),
                    200,
                    array('Content-Type'=>'application/json')
                );
            }

            $res = $this->deleteRegistro($em, $tInternacional);

            $this->addFlash($res['alert'], $res['message']);

            return $this->redirectToRoute('tinternacional_index');
        }
    }
    
}
