<?php

namespace App\Models;

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

use Symfony\Component\HttpFoundation\File\UploadedFile;

/**
 * Description of UploadFileMover
 *
 * @author Manoj
 */
class UploadFileMoverAny {

    public function moveUploadedFile(UploadedFile $file, $uploadBasePath,$relativePath) {
        
        $random= rand(1000,9999);
        $originalName = $file->getClientOriginalName();
        $name_array = explode('.',$originalName);
        $file_type = $name_array[sizeof($name_array) - 1];
        
        $file_name=time().$random.'.'.$file_type;
        
        //var_dump($file_name);exit();
        // use filemtime() to have a more determenistic way to determine the subpath, otherwise its hard to test.
       // $relativePath = date('Y-m', filemtime($file->getPath()));
        $targetFileName = $relativePath . DIRECTORY_SEPARATOR . $file_name;
        $targetFilePath = $uploadBasePath . DIRECTORY_SEPARATOR . $file_name;

        //var_dump($targetFilePath);exit();
        $targetDir = $uploadBasePath . DIRECTORY_SEPARATOR . $relativePath;
        if (!is_dir($targetDir)) {
            $ret = mkdir($targetDir, umask(), true);
            if (!$ret) {
                throw new \RuntimeException("No se pudo crear el Directorio para insertar el Archivo.");
            }
        }
        $file->move($targetDir, basename($targetFilePath));
        //var_dump($file);exit();
        return str_replace($uploadBasePath . DIRECTORY_SEPARATOR, "", $targetFilePath);
    }

}

?>
