<?php

namespace App\Form;

use App\Entity\Tusuario;
use App\Entity\Trol;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

use Symfony\Component\Form\Extension\Core\Type\EmailType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\Extension\Core\Type\FileType;

use Symfony\Component\Form\Extension\Core\Type\RepeatedType;
use Symfony\Component\Form\Extension\Core\Type\PasswordType;
use Symfony\Component\Form\Extension\Core\Type\CheckboxType;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;

class TusuarioType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $user = $options['usuario'];
//var_dump($user); exit();
        if (!$user)
            $banderaRol = 1;
        else {
            if($user == 1)
                $banderaRol = array(1, 2, 3, 4, 5);
            if($user == 2)
                $banderaRol = array(2, 3, 4, 5);
            if($user == 3)
                $banderaRol = array(3);
            if($user == 4)
                $banderaRol = array(4);
            if($user == 5)
                $banderaRol = array(5);
        }

        $builder
            ->add('username', TextType::class, array(
                'label'=>'Usuario',
                'attr'=>array('class'=>'form-control', 'style' => 'margin-bottom:10px', 'maxlength'=>50, 'onkeypress'=>'return controllet(event)')))

            ->add('plainPassword', RepeatedType::class, array(
                'type' => PasswordType::class,
                'invalid_message' => 'Las contraseñas deben coincidir.',
                'options' => array('attr' => array('class' => 'password-field')),
                'required' => true,
                'first_options'  => array('label' => 'Contraseña', 'attr'=>array('class'=>'form-control', 'style' => 'margin-bottom:10px', 'maxlength'=>15)),
                'second_options' => array('label' => 'Repita la Contraseña', 'attr'=>array('class'=>'form-control', 'style' => 'margin-bottom:10px', 'maxlength'=>15)),
            ))
            ->add('carnet',TextType::class,
                array('label'=>'No. de Carnet',
                    'attr'=>array('class'=>'form-control', 'style' => 'margin-bottom:10px', 'maxlength'=>8, 'onkeypress'=>'return controlnum(event)')))

            ->add('nombres',TextType::class,
                array('label'=>'Nombre Completo',
                    'attr'=>array('class'=>'form-control', 'style' => 'margin-bottom:10px', 'maxlength'=>100, 'onkeypress'=>'return controllet(event)')))

            ->add('celular',TextType::class,
                array('label'=>'No. de Celular',
                    'attr'=>array('class'=>'form-control', 'style' => 'margin-bottom:10px', 'maxlength'=>8, 'onkeypress'=>'return controlnum(event)')))

            ->add('correo', EmailType::class, array(
                'label'=>'Correo Electrónico: ',
                'attr'=>array('class'=>'form-control', 'style' => 'margin-bottom:10px', 'maxlength'=>100)))

            ->add('domicilio',TextType::class,
                array('label'=>'Dirección domicilio',
                    'attr'=>array('class'=>'form-control', 'style' => 'margin-bottom:10px', 'maxlength'=>200)))

            ->add('foto',FileType::class, array(
                'required'=>false, 'attr'=>array('class'=>'form-control dropify', 'style' => 'margin-bottom:10px'),
                'label'=>'Foto', 'data_class'=>null))

            ->add('observacion',TextType::class,
                array('label'=>'Observaciones',
                    'attr'=>array('class'=>'form-control', 'style' => 'margin-bottom:10px', 'maxlength'=>200)))
            
            ->add('estado',CheckboxType::class,
                array('required'=>false, 'label'=>'Estado','attr'=>array('class'=>'form-control', 'style' => 'margin-bottom:0px')))

            ->add('idrol', EntityType::class, [
                'label' => 'Rol del Usuario',
                'attr'=>array('class'=>'form-control', 'style' => 'margin-bottom:10px'),
                'class'=>Trol::class,
                'placeholder' => '---- Escoge un Rol',
                'query_builder' => function ($er) use ($banderaRol){
//			        global $bandera;
                    return $er->createQueryBuilder('p')
                        ->select('p') // Entity Rol
                        ->where('p.idrol IN (:tipoRol)')
                        ->setParameter('tipoRol', $banderaRol)
                        ;
                },
            ]);
        ;
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults([
            'data_class' => Tusuario::class,
            'usuario' => null
        ]);
    }
}
