<?php

namespace App\Form;

use App\Entity\Tdestino;
use App\Entity\Tempresa;
use App\Entity\Tnacional;
use App\Entity\Torigen;
use App\Entity\Tregnal;
use App\Entity\Tusuario;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\DateType;
use Symfony\Component\Form\Extension\Core\Type\FileType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Validator\Constraints\File;

class Tnacional_adjuntaType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('fechainicio',DateType::class, array(
                'widget'=>'single_text',
                'html5' => false,
                'input' => 'datetime',
                'label'=>'Fecha de Recepción',
                'format'=>'dd/MM/yyyy',
                'attr'=> ['class'=>'form-control mydatepicker', 'style' => 'margin-bottom:5px','placeholder'=>'dd/mm/yyyy']))

            ->add('observaciones',TextType::class,
                array('label'=>'Observaciones',
                    'attr'=>array('class'=>'form-control', 'style' => 'margin-bottom:10px', 'maxlength'=>250)))

//            ->add('auditoria')

            ->add('iddestino', EntityType::class, [
                'label' => 'Lugar de Destino',
                'attr'=>array('class'=>'form-control', 'style' => 'margin-bottom:10px'),
                'class' => Tdestino::class,
                'placeholder' => '---- Escoge un destino',
                'query_builder' => function ($er) {
                    return $er->createQueryBuilder('p')
                        ->select('p') // Entity Persona
//						->from(Persona::class, 'p')
                        ->where('p.abreviacion=:tipoPersona ')
                        ->setParameter('tipoPersona', 'Nacional')
                        ->orderBy('p.descripcion', 'ASC');
                },
            ])

            ->add('idempresa', EntityType::class, [
                'label' => 'Empresa',
                'attr'=>array('class'=>'form-control', 'style' => 'margin-bottom:10px'),
                'class' => Tempresa::class,
                'placeholder' => '---- Escoge una empresa',
            ])

//            ->add('idestado')

            ->add('idorigen', EntityType::class, [
                'label' => 'Lugar de Origen',
                'attr'=>array('class'=>'form-control', 'style' => 'margin-bottom:10px'),
                'class' => Torigen::class,
                'placeholder' => '---- Escoge un origen',
                'query_builder' => function ($er) {
                    return $er->createQueryBuilder('p')
                        ->select('p') // Entity Persona
//						->from(Persona::class, 'p')
                        ->where('p.abreviacion=:tipoPersona ')
                        ->setParameter('tipoPersona', 'Nacional')
                        ->orderBy('p.descripcion', 'ASC');
                },
            ])

        ;
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults([
            'data_class' => Tnacional::class,
        ]);
    }
}
