<?php

namespace App\Form;

use App\Entity\Tdestino;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\CheckboxType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

class TdestinoType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('descripcion',TextType::class,
                array('label'=>'Origen de Salida',
                    'attr'=>array('class'=>'form-control', 'style' => 'margin-bottom:10px', 'maxlength'=>150)))
            ->add('abreviacion', ChoiceType::class, array(
                'label'=>'Este Destino es: ',
                'attr'=>array('class'=>'form-control', 'style' => 'margin-bottom:10px', 'maxlength'=>20 ),
                'placeholder' => '----Escoge clasificación',
                'choices'   => array(
                    'Nacional' => 'Nacional',
                    'Internacional'   => 'Internacional',
                ),
                'multiple'  => false,
            ))
            ->add('estado',CheckboxType::class,
                array('required'=>false, 'label'=>'Estado','attr'=>array('class'=>'form-control', 'style' => 'margin-bottom:0px')))
        ;
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults([
            'data_class' => Tdestino::class,
        ]);
    }
}
