<?php

namespace App\Entity;

use Doctrine\ORM\Mapping as ORM;
use Symfony\Component\Validator\Constraints as Assert;
use Symfony\Bridge\Doctrine\Validator\Constraints\UniqueEntity;
use Symfony\Component\Security\Core\User\UserInterface;

/**
 * Tusuario
 *
 * @ORM\Table(name="tusuario", uniqueConstraints={@ORM\UniqueConstraint(name="UQ_tusuario_correo", columns={"correo"})}, indexes={@ORM\Index(name="idrol", columns={"idrol"})})
 * @ORM\Entity(repositoryClass="App\Repository\TusuarioRepository")
 */
class Tusuario implements UserInterface
{
    /**
     * @var int
     *
     * @ORM\Column(name="idusuario", type="smallint", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $idusuario;

    /**
     * @var string
     * @Assert\NotBlank(message="Este campo no puede estar en Blanco")
     *
     * @ORM\Column(name="username", type="string", length=50, nullable=false)
     */
    private $username;

    /**
     * @var string
     *
     * @ORM\Column(name="password", type="string", length=64, nullable=false)
     */
    private $password;

    /**
     * @var string
     * @Assert\NotBlank(message="Este campo no puede estar en Blanco")
     *
     * @ORM\Column(name="carnet", type="string", length=10, nullable=false)
     */
    private $carnet;

    /**
     * @var string
     * @Assert\NotBlank(message="Este campo no puede estar en Blanco")
     *
     * @ORM\Column(name="nombres", type="string", length=100, nullable=false)
     */
    private $nombres;

    /**
     * @var int|null
     *
     * @ORM\Column(name="celular", type="integer", nullable=true, options={"default"="NULL"})
     */
    private $celular = NULL;

    /**
     * @var string|null
     *
     * @ORM\Column(name="correo", type="string", length=80, nullable=true, options={"default"="NULL"})
     */
    private $correo = '';

    /**
     * @var string|null
     *
     * @ORM\Column(name="domicilio", type="string", length=250, nullable=true, options={"default"="NULL"})
     */
    private $domicilio = '';

    /**
     * @var string|null
     *
     * @ORM\Column(name="foto", type="string", length=50, nullable=true, options={"default"="NULL"})
     */
    private $foto = '';

    /**
     * @var string|null
     *
     * @ORM\Column(name="observacion", type="string", length=250, nullable=true, options={"default"="NULL"})
     */
    private $observacion = '';

    /**
     * @var bool|null
     *
     * @ORM\Column(name="estado", type="boolean", nullable=true, options={"default"="NULL"})
     */
    private $estado = '';

    /**
     * @var \Trol
     *
     * @ORM\ManyToOne(targetEntity="Trol")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="idrol", referencedColumnName="idrol")
     * })
     */
    private $idrol;

    public function getIdusuario(): ?int
    {
        return $this->idusuario;
    }

    public function getUsername(): ?string
    {
        return $this->username;
    }

    public function setUsername(string $username): self
    {
        $this->username = $username;

        return $this;
    }

    public function getPassword(): ?string
    {
        return $this->password;
    }

    public function setPassword(string $password): self
    {
        $this->password = $password;

        return $this;
    }

    public function getCarnet(): ?string
    {
        return $this->carnet;
    }

    public function setCarnet(string $carnet): self
    {
        $this->carnet = $carnet;

        return $this;
    }

    public function getNombres(): ?string
    {
        return $this->nombres;
    }

    public function setNombres(string $nombres): self
    {
        $this->nombres = $nombres;

        return $this;
    }

    public function getCelular(): ?int
    {
        return $this->celular;
    }

    public function setCelular(?int $celular): self
    {
        $this->celular = $celular;

        return $this;
    }

    public function getCorreo(): ?string
    {
        return $this->correo;
    }

    public function setCorreo(?string $correo): self
    {
        $this->correo = $correo;

        return $this;
    }

    public function getDomicilio(): ?string
    {
        return $this->domicilio;
    }

    public function setDomicilio(?string $domicilio): self
    {
        $this->domicilio = $domicilio;

        return $this;
    }

    public function getFoto(): ?string
    {
        return $this->foto;
    }

    public function setFoto(?string $foto): self
    {
        $this->foto = $foto;

        return $this;
    }

    public function getObservacion(): ?string
    {
        return $this->observacion;
    }

    public function setObservacion(?string $observacion): self
    {
        $this->observacion = $observacion;

        return $this;
    }

    public function getEstado(): ?bool
    {
        return $this->estado;
    }

    public function setEstado(?bool $estado): self
    {
        $this->estado = $estado;

        return $this;
    }

    public function getIdrol(): ?Trol
    {
        return $this->idrol;
    }

    public function setIdrol(?Trol $idrol): self
    {
        $this->idrol = $idrol;

        return $this;
    }



    //METODOS QUE DE DEBE IMPLMENTAR LA ENTITY POR USO DE INTERFACE

    /**
     * @Assert\Length(max=4096)
     */
    private $plainPassword;

    /**
     *
     * @ORM\Column(type="string", length=256)
     */
    private $roles;

    public function getPlainPassword()
    {
        return $this->plainPassword;
    }

    public function setPlainPassword($password)
    {
        $this->plainPassword = $password;
    }

    public function getSalt()
    {
        // The bcrypt and argon2i algorithms don't require a separate salt.
        // You *may* need a real salt if you choose a different encoder.
        return null;
    }

    public function setRoles($roles)
    {
        $roles_json=json_encode($roles);
        return $this->roles = $roles_json;
    }

    public function getRoles()
    {
//		return array($this->getIdRol());
//		return array('ROLE_SUPER');
        $roles=json_decode($this->roles);
        return $roles;
    }

    public function eraseCredentials()
    {

    }

    public function __toString()
    {
        return $this->getNombres();
    }

}
