<?php

namespace App\Entity;

use Doctrine\ORM\Mapping as ORM;

// obligatorio colocar es para la validación de los formularios por anotacioón
use Symfony\Component\Validator\Constraints as Assert;
/**
 * Tregnal
 *
 * @ORM\Table(name="tregnal", indexes={@ORM\Index(name="idpago", columns={"idpago"}), @ORM\Index(name="idnacional", columns={"idnacional"}), @ORM\Index(name="idusuario", columns={"idusuario"}), @ORM\Index(name="idmovimiento", columns={"idmovimiento"}), @ORM\Index(name="idusuario2", columns={"idusuario2"})})
 * @ORM\Entity
 */
class Tregnal
{
    /**
     * @var int
     *
     * @ORM\Column(name="idregnal", type="smallint", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $idregnal;

    /**
     * @var \DateTime|null
     *
     * @ORM\Column(name="fecharegistro", type="datetime", nullable=true, options={"default"="CURRENT_TIMESTAMP"})
     */
    private $fecharegistro;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="fechaentrega", type="datetime", nullable=false)
     */
    private $fechaentrega;

    /**
     * @var string
     *
     * @ORM\Column(name="chasis", type="string", length=20, nullable=false)
     */
    private $chasis;

    /**
     * @var string
     *
     * @ORM\Column(name="marca", type="string", length=50, nullable=false)
     */
    private $marca;

    /**
     * @var string
     *
     * @ORM\Column(name="modelo", type="string", length=100, nullable=false)
     */
    private $modelo;

    /**
     * @var \DateTime|null
     *
     * @ORM\Column(name="fechapago", type="datetime", nullable=true, options={"default"="NULL"})
     */
    private $fechapago;

    /**
     * @var string|null
     *
     * @ORM\Column(name="observaciones", type="string", length=1000, nullable=true, options={"default"="NULL"})
     */
    private $observaciones = '';

    /**
     * @var string|null
     *
     * @ORM\Column(name="observaciondesc", type="string", length=1000, nullable=true, options={"default"="NULL"})
     */
    private $observaciondesc = '';

    /**
     * @var string|null
     *
     * @ORM\Column(name="auditoria", type="string", length=10000, nullable=true, options={"default"="NULL"})
     */
    private $auditoria = '';

    /**
     * @var int
     *
     * @ORM\Column(name="factura", type="integer", nullable=false)
     */
    private $factura;

    /**
     * @var string|null
     *
     * @ORM\Column(name="archivo", type="string", length=50, nullable=true, options={"default"="NULL"})
     */
    private $archivo = '';


    /**
     * @var string
     * @ORM\Column(name="montopagar", type="string", length=50, nullable=false, options={"default"="0"})
     * @Assert\NotBlank(
     *      message = "No puede estar en blanco",
     *)
     * @Assert\Type(
     *     type="numeric",
     *     message="Valor numérico entero o fracción Ejm. 95.00"
     * )
     */
    private $montopagar;

    /**
     * @var string
     * @ORM\Column(name="descuento", type="string", length=50, nullable=false, options={"default"="0"})
     * @Assert\NotBlank(
     *      message = "No puede estar en blanco",
     *)
     * @Assert\Type(
     *     type="numeric",
     *     message="Valor numérico entero o fracción Ejm. 95.00"
     * )
     */
    private $descuento;

    /**
     * @var string
     * @ORM\Column(name="montopagado", type="string", length=50, nullable=false, options={"default"="0"})
     * @Assert\NotBlank(
     *      message = "No puede estar en blanco",
     *)
     * @Assert\Type(
     *     type="numeric",
     *     message="Valor numérico entero o fracción Ejm. 95.00"
     * )
     */
    private $montopagado;

    /**
     * @var \Tnacional
     *
     * @ORM\ManyToOne(targetEntity="Tnacional")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="idnacional", referencedColumnName="idnacional")
     * })
     */
    private $idnacional;

    /**
     * @var \Tusuario
     *
     * @ORM\ManyToOne(targetEntity="Tusuario")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="idusuario", referencedColumnName="idusuario")
     * })
     */
    private $idusuario;



    /**
     * @var \Tusuario
     *
     * @ORM\ManyToOne(targetEntity="Tusuario")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="idusuario2", referencedColumnName="idusuario")
     * })
     */
    private $idusuario2;


    /**
     * @var \Tmovimiento
     *
     * @ORM\ManyToOne(targetEntity="Tmovimiento")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="idmovimiento", referencedColumnName="idmovimiento")
     * })
     */
    private $idmovimiento;


    /**
     * @var \Tpago
     *
     * @ORM\ManyToOne(targetEntity="Tpago")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="idpago", referencedColumnName="idpago")
     * })
     */
    private $idpago;


    /**
     * @var \DateTime|null
     *
     * @ORM\Column(name="fechasalida", type="datetime", nullable=true, options={"default"="NULL"})
     */
    private $fechasalida;



    public function getIdregnal(): ?int
    {
        return $this->idregnal;
    }

    public function getFecharegistro(): ?\DateTimeInterface
    {
        return $this->fecharegistro;
    }

    public function setFecharegistro(\DateTimeInterface $fecharegistro): self
    {
        $this->fecharegistro = $fecharegistro;

        return $this;
    }

    public function getFechaentrega(): ?\DateTimeInterface
    {
        return $this->fechaentrega;
    }

    public function setFechaentrega(\DateTimeInterface $fechaentrega): self
    {
        $this->fechaentrega = $fechaentrega;

        return $this;
    }

    public function getChasis(): ?string
    {
        return $this->chasis;
    }

    public function setChasis(string $chasis): self
    {
        $this->chasis = $chasis;

        return $this;
    }

    public function getMarca(): ?string
    {
        return $this->marca;
    }

    public function setMarca(string $marca): self
    {
        $this->marca = $marca;

        return $this;
    }

    public function getModelo(): ?string
    {
        return $this->modelo;
    }

    public function setModelo(string $modelo): self
    {
        $this->modelo = $modelo;

        return $this;
    }

    public function getFechapago(): ?\DateTimeInterface
    {
        return $this->fechapago;
    }

    public function setFechapago(?\DateTimeInterface $fechapago): self
    {
        $this->fechapago = $fechapago;

        return $this;
    }

    public function getObservaciones(): ?string
    {
        return $this->observaciones;
    }

    public function setObservaciones(?string $observaciones): self
    {
        $this->observaciones = $observaciones;

        return $this;
    }

    public function getAuditoria(): ?string
    {
        return $this->auditoria;
    }

    public function setAuditoria(?string $auditoria): self
    {
        $this->auditoria = $auditoria;

        return $this;
    }

    public function getIdnacional(): ?Tnacional
    {
        return $this->idnacional;
    }

    public function setIdnacional(?Tnacional $idnacional): self
    {
        $this->idnacional = $idnacional;

        return $this;
    }

    public function getIdusuario(): ?Tusuario
    {
        return $this->idusuario;
    }

    public function setIdusuario(?Tusuario $idusuario): self
    {
        $this->idusuario = $idusuario;

        return $this;
    }

    public function getIdusuario2(): ?Tusuario
    {
        return $this->idusuario2;
    }

    public function setIdusuario2(?Tusuario $idusuario2): self
    {
        $this->idusuario2 = $idusuario2;

        return $this;
    }

    public function getIdmovimiento(): ?Tmovimiento
    {
        return $this->idmovimiento;
    }

    public function setIdmovimiento(?Tmovimiento $idmovimiento): self
    {
        $this->idmovimiento = $idmovimiento;

        return $this;
    }

    public function getFechasalida(): ?\DateTimeInterface
    {
        return $this->fechasalida;
    }

    public function setFechasalida(?\DateTimeInterface $fechasalida): self
    {
        $this->fechasalida = $fechasalida;

        return $this;
    }

    public function getArchivo(): ?string
    {
        return $this->archivo;
    }

    public function setArchivo(?string $archivo): self
    {
        $this->archivo = $archivo;

        return $this;
    }

    public function getFactura(): ?int
    {
        return $this->factura;
    }

    public function setFactura(int $factura): self
    {
        $this->factura = $factura;

        return $this;
    }

    public function getObservaciondesc(): ?string
    {
        return $this->observaciondesc;
    }

    public function setObservaciondesc(?string $observaciondesc): self
    {
        $this->observaciondesc = $observaciondesc;

        return $this;
    }

    public function getMontopagar(): ?string
    {
        return $this->montopagar;
    }

    public function setMontopagar(string $montopagar): self
    {
        $this->montopagar = $montopagar;

        return $this;
    }

    public function getDescuento(): ?string
    {
        return $this->descuento;
    }

    public function setDescuento(string $descuento): self
    {
        $this->descuento = $descuento;

        return $this;
    }

    public function getMontopagado(): ?string
    {
        return $this->montopagado;
    }

    public function setMontopagado(string $montopagado): self
    {
        $this->montopagado = $montopagado;

        return $this;
    }

    public function getIdpago(): ?Tpago
    {
        return $this->idpago;
    }

    public function setIdpago(?Tpago $idpago): self
    {
        $this->idpago = $idpago;

        return $this;
    }


}
