<?php

namespace App\Entity;

use Doctrine\ORM\Mapping as ORM;
// obligatorio colocar es para la validación de los formularios por anotacioón
use Symfony\Component\Validator\Constraints as Assert;
/**
 * Tinternacional
 *
 * @ORM\Table(name="tinternacional", indexes={@ORM\Index(name="idcamion", columns={"idcamion"}), @ORM\Index(name="idempresa", columns={"idempresa"}), @ORM\Index(name="idempresa2", columns={"idempresa2"}), @ORM\Index(name="idpago", columns={"idpago"}), @ORM\Index(name="idorigen", columns={"idorigen"}), @ORM\Index(name="iddestino", columns={"iddestino"}), @ORM\Index(name="idservicio", columns={"idservicio"}), @ORM\Index(name="idestado", columns={"idestado"}), @ORM\Index(name="idusuario", columns={"idusuario"})})
 * @ORM\Entity
 */
class Tinternacional
{
    /**
     * @var int
     *
     * @ORM\Column(name="idinternacional", type="smallint", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $idinternacional;

    /**
     * @var string
     * @Assert\NotBlank()
     *
     * @ORM\Column(name="cant", type="string", length=10, nullable=false)
     */
    private $cant;
    
    /**
     * @var int
     *
     * @ORM\Column(name="micdta", type="integer", nullable=false)
     * @Assert\NotBlank()
     */
    private $micdta;

    /**
     * @var \DateTime|null
     *
     * @ORM\Column(name="fechasalida", type="datetime", nullable=true, options={"default"="CURRENT_TIMESTAMP"})
     * @Assert\NotBlank()
     */
    private $fechasalida;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="fechaentrega", type="datetime", nullable=true)
     */
    private $fechaentrega;

    /**
     * @var \DateTime|null
     *
     * @ORM\Column(name="fcobrofact", type="datetime", nullable=true, options={"default"="CURRENT_TIMESTAMP"})
     */
    private $fcobrofact;

    /**
     * @var \DateTime|null
     *
     * @ORM\Column(name="fpagofact", type="datetime", nullable=true, options={"default"="CURRENT_TIMESTAMP"})
     */
    private $fpagofact;


    /**
     * @var bool|null
     *
     * @ORM\Column(name="mic", type="boolean", nullable=true, options={"default"="NULL"})
     */
    private $mic = '0';

    /**
     * @var bool|null
     *
     * @ORM\Column(name="crt", type="boolean", nullable=true, options={"default"="NULL"})
     */
    private $crt = '0';

    /**
     * @var bool|null
     *
     * @ORM\Column(name="pr", type="boolean", nullable=true, options={"default"="NULL"})
     */
    private $pr = '0';

    /**
     * @var bool|null
     *
     * @ORM\Column(name="inv", type="boolean", nullable=true, options={"default"="NULL"})
     */
    private $inv = '0';

    /**
     * @var bool|null
     *
     * @ORM\Column(name="cn", type="boolean", nullable=true, options={"default"="NULL"})
     */
    private $cn = '0';

    /**
     * @var int
     *
     * @ORM\Column(name="fac", type="integer", nullable=false)
     */
    private $fac = '0';

    /**
     * @var string
     * @ORM\Column(name="monto", type="string", length=50, nullable=true, options={"default"="0"})
     * @Assert\Type(
     *     type="numeric",
     *     message="Valor numérico entero o fracción Ejm. 95.00"
     * )
     */
    private $monto;

    /**
     * @var string
     * @ORM\Column(name="flete", type="string", length=50, nullable=false, options={"default"="0"})
     * @Assert\NotBlank(
     *      message = "No puede estar en blanco",
     *)
     * @Assert\Type(
     *     type="numeric",
     *     message="Valor numérico entero o fracción Ejm. 95.00"
     * )
     */
    private $flete = '0';

    /**
     * @var string
     * @ORM\Column(name="descuento", type="string", length=50, nullable=true, options={"default"="0"})
     * @Assert\Type(
     *     type="numeric",
     *     message="Valor numérico entero o fracción Ejm. 95.00"
     * )
     */
    private $descuento=0;

    /**
     * @var string|null
     *
     * @ORM\Column(name="observacion", type="string", length=1000, nullable=true, options={"default"="NULL"})
     */
    private $observacion = '';

    /**
     * @var string|null
     *
     * @ORM\Column(name="observaciondesc", type="string", length=1000, nullable=true, options={"default"="NULL"})
     */
    private $observaciondesc = '';

    /**
     * @var string|null
     *
     * @ORM\Column(name="archivo", type="string", length=50, nullable=true, options={"default"="NULL"})
     */
    private $archivo = '';

    /**
     * @var string|null
     *
     * @ORM\Column(name="auditoria", type="string", length=10000, nullable=true, options={"default"="NULL"})
     */
    private $auditoria = '';


    /**
     * @var \Tcamion
     *
     * @ORM\ManyToOne(targetEntity="Tcamion")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="idcamion", referencedColumnName="idcamion")
     * })
     * @Assert\NotBlank()
     */
    private $idcamion;

    /**
     * @var \Tdestino
     *
     * @ORM\ManyToOne(targetEntity="Tdestino")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="iddestino", referencedColumnName="iddestino")
     * })
     * @Assert\NotBlank()
     */
    private $iddestino;

    /**
     * @var \Testado
     *
     * @ORM\ManyToOne(targetEntity="Testado")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="idestado", referencedColumnName="idestado")
     * })
     */
    private $idestado;

    /**
     * @var \Tpago
     *
     * @ORM\ManyToOne(targetEntity="Tpago")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="idpago", referencedColumnName="idpago")
     * })
     */
    private $idpago;

    /**
     * @var \Tservicio
     *
     * @ORM\ManyToOne(targetEntity="Tservicio")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="idservicio", referencedColumnName="idservicio")
     * })
     * @Assert\NotBlank()
     */
    private $idservicio;

    /**
     * @var \Tusuario
     *
     * @ORM\ManyToOne(targetEntity="Tusuario")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="idusuario", referencedColumnName="idusuario")
     * })
     */
    private $idusuario;

    /**
     * @var \Tempresa
     *
     * @ORM\ManyToOne(targetEntity="Tempresa")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="idempresa", referencedColumnName="idempresa")
     * })
     * @Assert\NotBlank()
     */
    private $idempresa;

    /**
     * @var \Tempresa
     *
     * @ORM\ManyToOne(targetEntity="Tempresa")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="idempresa2", referencedColumnName="idempresa")
     * })
     * @Assert\NotBlank()
     */
    private $idempresa2;

    /**
     * @var \Torigen
     *
     * @ORM\ManyToOne(targetEntity="Torigen")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="idorigen", referencedColumnName="idorigen")
     * })
     * @Assert\NotBlank()
     */
    private $idorigen;

    public function getIdinternacional(): ?int
    {
        return $this->idinternacional;
    }

    public function getMicdta(): ?int
    {
        return $this->micdta;
    }

    public function setMicdta(int $micdta): self
    {
        $this->micdta = $micdta;

        return $this;
    }

    public function getFechaentrega(): ?\DateTimeInterface
    {
        return $this->fechaentrega;
    }

    public function setFechaentrega(\DateTimeInterface $fechaentrega): self
    {
        $this->fechaentrega = $fechaentrega;

        return $this;
    }

    public function getMic(): ?bool
    {
        return $this->mic;
    }

    public function setMic(?bool $mic): self
    {
        $this->mic = $mic;

        return $this;
    }

    public function getCrt(): ?bool
    {
        return $this->crt;
    }

    public function setCrt(?bool $crt): self
    {
        $this->crt = $crt;

        return $this;
    }

    public function getPr(): ?bool
    {
        return $this->pr;
    }

    public function setPr(?bool $pr): self
    {
        $this->pr = $pr;

        return $this;
    }

    public function getInv(): ?bool
    {
        return $this->inv;
    }

    public function setInv(?bool $inv): self
    {
        $this->inv = $inv;

        return $this;
    }

    public function getCn(): ?bool
    {
        return $this->cn;
    }

    public function setCn(?bool $cn): self
    {
        $this->cn = $cn;

        return $this;
    }

    public function getFechacobra(): ?\DateTimeInterface
    {
        return $this->fechacobra;
    }

    public function setFechacobra(?\DateTimeInterface $fechacobra): self
    {
        $this->fechacobra = $fechacobra;

        return $this;
    }

    public function getFlete(): ?string
    {
        return $this->flete;
    }

    public function setFlete(?string $flete): self
    {
        $this->flete = $flete;

        return $this;
    }

    public function getCobrador(): ?string
    {
        return $this->cobrador;
    }

    public function setCobrador(?string $cobrador): self
    {
        $this->cobrador = $cobrador;

        return $this;
    }

    public function getObservacion(): ?string
    {
        return $this->observacion;
    }

    public function setObservacion(?string $observacion): self
    {
        $this->observacion = $observacion;

        return $this;
    }

    public function getAuditoria(): ?string
    {
        return $this->auditoria;
    }

    public function setAuditoria(?string $auditoria): self
    {
        $this->auditoria = $auditoria;

        return $this;
    }

    public function getIdcamion(): ?Tcamion
    {
        return $this->idcamion;
    }

    public function setIdcamion(?Tcamion $idcamion): self
    {
        $this->idcamion = $idcamion;

        return $this;
    }

    public function getIddestino(): ?Tdestino
    {
        return $this->iddestino;
    }

    public function setIddestino(?Tdestino $iddestino): self
    {
        $this->iddestino = $iddestino;

        return $this;
    }

    public function getIdestado(): ?Testado
    {
        return $this->idestado;
    }

    public function setIdestado(?Testado $idestado): self
    {
        $this->idestado = $idestado;

        return $this;
    }

    public function getIdpago(): ?Tpago
    {
        return $this->idpago;
    }

    public function setIdpago(?Tpago $idpago): self
    {
        $this->idpago = $idpago;

        return $this;
    }

    public function getIdservicio(): ?Tservicio
    {
        return $this->idservicio;
    }

    public function setIdservicio(?Tservicio $idservicio): self
    {
        $this->idservicio = $idservicio;

        return $this;
    }

    public function getIdusuario(): ?Tusuario
    {
        return $this->idusuario;
    }

    public function setIdusuario(?Tusuario $idusuario): self
    {
        $this->idusuario = $idusuario;

        return $this;
    }

    public function getFechasalida(): ?\DateTimeInterface
    {
        return $this->fechasalida;
    }

    public function setFechasalida(?\DateTimeInterface $fechasalida): self
    {
        $this->fechasalida = $fechasalida;

        return $this;
    }

    public function getFcobrofact(): ?\DateTimeInterface
    {
        return $this->fcobrofact;
    }

    public function setFcobrofact(?\DateTimeInterface $fcobrofact): self
    {
        $this->fcobrofact = $fcobrofact;

        return $this;
    }

    public function getFpagofact(): ?\DateTimeInterface
    {
        return $this->fpagofact;
    }

    public function setFpagofact(?\DateTimeInterface $fpagofact): self
    {
        $this->fpagofact = $fpagofact;

        return $this;
    }

    public function getMonto(): ?string
    {
        return $this->monto;
    }

    public function setMonto(string $monto): self
    {
        $this->monto = $monto;

        return $this;
    }

    public function getDescuento(): ?string
    {
        return $this->descuento;
    }

    public function setDescuento(string $descuento): self
    {
        $this->descuento = $descuento;

        return $this;
    }

    public function getObservaciondesc(): ?string
    {
        return $this->observaciondesc;
    }

    public function setObservaciondesc(?string $observaciondesc): self
    {
        $this->observaciondesc = $observaciondesc;

        return $this;
    }

    public function getArchivo(): ?string
    {
        return $this->archivo;
    }

    public function setArchivo(?string $archivo): self
    {
        $this->archivo = $archivo;

        return $this;
    }

    public function getIdempresa(): ?Tempresa
    {
        return $this->idempresa;
    }

    public function setIdempresa(?Tempresa $idempresa): self
    {
        $this->idempresa = $idempresa;

        return $this;
    }

    public function getIdempresa2(): ?Tempresa
    {
        return $this->idempresa2;
    }

    public function setIdempresa2(?Tempresa $idempresa2): self
    {
        $this->idempresa2 = $idempresa2;

        return $this;
    }

    public function getIdorigen(): ?Torigen
    {
        return $this->idorigen;
    }

    public function setIdorigen(?Torigen $idorigen): self
    {
        $this->idorigen = $idorigen;

        return $this;
    }

    public function getCant(): ?string
    {
        return $this->cant;
    }

    public function setCant(string $cant): self
    {
        $this->cant = $cant;

        return $this;
    }

    public function getFac(): ?int
    {
        return $this->fac;
    }

    public function setFac(int $fac): self
    {
        $this->fac = $fac;

        return $this;
    }


}
