<?php

namespace App\Entity;

use Doctrine\ORM\Mapping as ORM;

// obligatorio colocar es para la validación de los formularios por anotacioón
use Symfony\Component\Validator\Constraints as Assert;

/**
 * Tfactnal
 *
 * @ORM\Table(name="tfactnal", indexes={@ORM\Index(name="idpago", columns={"idpago"}), @ORM\Index(name="idusuario", columns={"idusuario"}), @ORM\Index(name="idnacional", columns={"idnacional"}) })
 * @ORM\Entity
 */
class Tfactnal
{
    /**
     * @var int
     *
     * @ORM\Column(name="idfactnal", type="smallint", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $idfactnal;

    /**
     * @var \DateTime|null
     *
     * @ORM\Column(name="fcobrofact", type="datetime", nullable=true, options={"default"="CURRENT_TIMESTAMP"})
     * @Assert\NotBlank
     */
    private $fcobrofact;


    /**
     * @var int|null
     *
     * @ORM\Column(name="factura", type="integer", nullable=true, options={"default"="NULL"})
     * @Assert\NotBlank
     */
    private $factura = NULL;

    /**
     * @var \DateTime|null
     *
     * @ORM\Column(name="fpagofact", type="datetime", nullable=true, options={"default"="CURRENT_TIMESTAMP"})
     */
    private $fpagofact;

    /**
     * @var string
     * @ORM\Column(name="monto", type="string", length=50, nullable=false, options={"default"="0"})
     * @Assert\NotBlank(
     *      message = "No puede estar en blanco",
     *)
     * @Assert\Type(
     *     type="numeric",
     *     message="Valor numérico entero o fracción Ejm. 95.00"
     * )
     */
    private $monto;

    /**
     * @var string|null
     *
     * @ORM\Column(name="observacion", type="string", length=1000, nullable=true, options={"default"="NULL"})
     */
    private $observacion = '';

    /**
     * @var string|null
     *
     * @ORM\Column(name="auditoria", type="string", length=10000, nullable=true, options={"default"="NULL"})
     */
    private $auditoria = '';


    /**
     * @var \Tpago
     *
     * @ORM\ManyToOne(targetEntity="Tpago")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="idpago", referencedColumnName="idpago")
     * })
     */
    private $idpago;

    /**
     * @var \Tnacional
     *
     * @ORM\ManyToOne(targetEntity="Tnacional")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="idnacional", referencedColumnName="idnacional")
     * })
     */
    private $idnacional;

    /**
     * @var \Tusuario
     *
     * @ORM\ManyToOne(targetEntity="Tusuario")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="idusuario", referencedColumnName="idusuario")
     * })
     */
    private $idusuario;


public function getIdfactnal(): ?int
{
    return $this->idfactnal;
}

public function getFcobrofact(): ?\DateTimeInterface
{
    return $this->fcobrofact;
}

public function setFcobrofact(?\DateTimeInterface $fcobrofact): self
{
    $this->fcobrofact = $fcobrofact;

    return $this;
}

public function getFactura(): ?int
{
    return $this->factura;
}

public function setFactura(?int $factura): self
{
    $this->factura = $factura;

    return $this;
}

public function getFpagofact(): ?\DateTimeInterface
{
    return $this->fpagofact;
}

public function setFpagofact(?\DateTimeInterface $fpagofact): self
{
    $this->fpagofact = $fpagofact;

    return $this;
}

public function getObservacion(): ?string
{
    return $this->observacion;
}

public function setObservacion(?string $observacion): self
{
    $this->observacion = $observacion;

    return $this;
}

public function getAuditoria(): ?string
{
    return $this->auditoria;
}

public function setAuditoria(?string $auditoria): self
{
    $this->auditoria = $auditoria;

    return $this;
}

public function getIdpago(): ?Tpago
{
    return $this->idpago;
}

public function setIdpago(?Tpago $idpago): self
{
    $this->idpago = $idpago;

    return $this;
}

public function getIdnacional(): ?Tnacional
{
    return $this->idnacional;
}

public function setIdnacional(?Tnacional $idnacional): self
{
    $this->idnacional = $idnacional;

    return $this;
}

public function getIdusuario(): ?Tusuario
{
    return $this->idusuario;
}

public function setIdusuario(?Tusuario $idusuario): self
{
    $this->idusuario = $idusuario;

    return $this;
}

public function getMonto(): ?string
{
    return $this->monto;
}

public function setMonto(string $monto): self
{
    $this->monto = $monto;

    return $this;
}


}
