<?php

namespace App\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * Testado
 *
 * @ORM\Table(name="testado")
 * @ORM\Entity
 */
class Testado
{
    /**
     * @var int
     *
     * @ORM\Column(name="idestado", type="smallint", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $idestado;

    /**
     * @var string
     *
     * @ORM\Column(name="descripcion", type="string", length=50, nullable=false)
     */
    private $descripcion;

    /**
     * @var string
     *
     * @ORM\Column(name="nalint", type="string", length=3, nullable=false)
     */
    private $nalint;

    public function getIdestado(): ?int
    {
        return $this->idestado;
    }

    public function getDescripcion(): ?string
    {
        return $this->descripcion;
    }

    public function setDescripcion(string $descripcion): self
    {
        $this->descripcion = $descripcion;

        return $this;
    }

    public function getNalint(): ?string
    {
        return $this->nalint;
    }

    public function setNalint(string $nalint): self
    {
        $this->nalint = $nalint;

        return $this;
    }

    public function __toString()
    {
        return $this->getDescripcion();
    }

}
