<?php

namespace App\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * Tdestino
 *
 * @ORM\Table(name="tdestino")
 * @ORM\Entity
 */
class Tdestino
{
    /**
     * @var int
     *
     * @ORM\Column(name="iddestino", type="smallint", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $iddestino;

    /**
     * @var string
     *
     * @ORM\Column(name="descripcion", type="string", length=100, nullable=false)
     */
    private $descripcion;

    /**
     * @var string|null
     *
     * @ORM\Column(name="abreviacion", type="string", length=20, nullable=true, options={"default"="NULL"})
     */
    private $abreviacion = '';


    /**
     * @var bool|null
     *
     * @ORM\Column(name="estado", type="boolean", nullable=true)
     */
    private $estado;


    public function getIddestino(): ?int
    {
        return $this->iddestino;
    }

    public function getDescripcion(): ?string
    {
        return $this->descripcion;
    }

    public function setDescripcion(string $descripcion): self
    {
        $this->descripcion = $descripcion;

        return $this;
    }

    public function getAbreviacion(): ?string
    {
        return $this->abreviacion;
    }

    public function setAbreviacion(?string $abreviacion): self
    {
        $this->abreviacion = $abreviacion;

        return $this;
    }

    public function getEstado(): ?bool
    {
        return $this->estado;
    }

    public function setEstado(?bool $estado): self
    {
        $this->estado = $estado;

        return $this;
    }

    public function __toString()
    {
        return $this->getDescripcion();
    }
}
