<?php

namespace App\Controller;

use App\Entity\Tfactinternal;
use App\Form\TfactinternalType;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;

/**
 * @Route("/tfactinternal")
 */
class TfactinternalController extends AbstractController
{
    /**
     * @Route("/", name="tfactinternal_index", methods={"GET"})
     */
    public function index(): Response
    {
        $tfactinternals = $this->getDoctrine()
            ->getRepository(Tfactinternal::class)
            ->findAll();

        return $this->render('tfactinternal/index.html.twig', [
            'tfactinternals' => $tfactinternals,
        ]);
    }

    /**
     * @Route("/new", name="tfactinternal_new", methods={"GET","POST"})
     */
    public function new(Request $request): Response
    {
        $tfactinternal = new Tfactinternal();
        $form = $this->createForm(TfactinternalType::class, $tfactinternal);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $entityManager = $this->getDoctrine()->getManager();
            $entityManager->persist($tfactinternal);
            $entityManager->flush();

            return $this->redirectToRoute('tfactinternal_index');
        }

        return $this->render('tfactinternal/new.html.twig', [
            'tfactinternal' => $tfactinternal,
            'form' => $form->createView(),
        ]);
    }

    /**
     * @Route("/{idfactinternal}", name="tfactinternal_show", methods={"GET"})
     */
    public function show(Tfactinternal $tfactinternal): Response
    {
        return $this->render('tfactinternal/show.html.twig', [
            'tfactinternal' => $tfactinternal,
        ]);
    }

    /**
     * @Route("/{idfactinternal}/edit", name="tfactinternal_edit", methods={"GET","POST"})
     */
    public function edit(Request $request, Tfactinternal $tfactinternal): Response
    {
        $form = $this->createForm(TfactinternalType::class, $tfactinternal);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $this->getDoctrine()->getManager()->flush();

            return $this->redirectToRoute('tfactinternal_index');
        }

        return $this->render('tfactinternal/edit.html.twig', [
            'tfactinternal' => $tfactinternal,
            'form' => $form->createView(),
        ]);
    }

    /**
     * @Route("/{idfactinternal}", name="tfactinternal_delete", methods={"DELETE"})
     */
    public function delete(Request $request, Tfactinternal $tfactinternal): Response
    {
        if ($this->isCsrfTokenValid('delete'.$tfactinternal->getIdfactinternal(), $request->request->get('_token'))) {
            $entityManager = $this->getDoctrine()->getManager();
            $entityManager->remove($tfactinternal);
            $entityManager->flush();
        }

        return $this->redirectToRoute('tfactinternal_index');
    }
}
