<?php

namespace App\Controller;

use App\Entity\Tdestino;
use App\Form\TdestinoType;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;

/**
 * @Route("/tdestino")
 */
class TdestinoController extends AbstractController
{
    /**
     * @Route("/", name="tdestino_index", methods={"GET"})
     */
    public function index(): Response
    {
        $tdestinos = $this->getDoctrine()
            ->getRepository(Tdestino::class)
            ->findAll();

        $deleteFormAjax = $this->createCustomForm(':USER_ID', 'DELETE', 'tdestino_delete');
        
        return $this->render('tdestino/index.html.twig', [
            'tdestinos' => $tdestinos,
            'delete_form_ajax' => $deleteFormAjax->createView()
        ]);
    }

    /**
     * @Route("/new", name="tdestino_new", methods={"GET","POST"})
     */
    public function new(Request $request): Response
    {
        $tdestino = new Tdestino();
        $form = $this->createForm(TdestinoType::class, $tdestino);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $entityManager = $this->getDoctrine()->getManager();
            $entityManager->persist($tdestino);
            $entityManager->flush();

            $this->addFlash('mensaje', 'Se creó el destino exitósamente');
            return $this->redirectToRoute('tdestino_index');
        }

        return $this->render('tdestino/new.html.twig', [
            'tdestino' => $tdestino,
            'form' => $form->createView(),
        ]);
    }

    /**
     * @Route("/{iddestino}", name="tdestino_show", methods={"GET"})
     */
    public function show(Tdestino $tdestino): Response
    {
        return $this->render('tdestino/show.html.twig', [
            'tdestino' => $tdestino,
        ]);
    }

    /**
     * @Route("/{iddestino}/edit", name="tdestino_edit", methods={"GET","POST"})
     */
    public function edit(Request $request, Tdestino $tdestino): Response
    {
        $form = $this->createForm(TdestinoType::class, $tdestino);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $this->getDoctrine()->getManager()->flush();

            $this->addFlash('mensaje', 'Se actualizó el destino exitósamente');
            return $this->redirectToRoute('tdestino_index');
        }

        return $this->render('tdestino/edit.html.twig', [
            'tdestino' => $tdestino,
            'form' => $form->createView(),
        ]);
    }

//    /**
//     * @Route("/{iddestino}", name="tdestino_delete", methods={"DELETE"})
//     */
//    public function delete(Request $request, Tdestino $tdestino): Response
//    {
//        if ($this->isCsrfTokenValid('delete'.$tdestino->getIddestino(), $request->request->get('_token'))) {
//            $entityManager = $this->getDoctrine()->getManager();
//            $entityManager->remove($tdestino);
//            $entityManager->flush();
//        }
//
//        return $this->redirectToRoute('tdestino_index');
//    }



    private function createCustomForm($id, $method, $route)
    {
        return $this->createFormBuilder()
            ->setAction($this->generateUrl($route, array('id'=>$id)))
            ->setMethod($method)
            ->getForm();
    }


    private function deleteRegistro($em, $tDestino)
    {
        $em->remove($tDestino);
        $em->flush();

        $message = 'El destino de llegada ha sido eliminado exitósamente';
        //$this->get('session')->getFlashBag()->add('message', 'Se eliminó el registro exitosamente');
        $removed = 1;
        $alert = 'mensaje';

        return array('removed'=>$removed, 'message'=>$message, 'alert'=>$alert);
    }


    /**
     * @Route("/delete/{id}", name="tdestino_delete")
     */
    public function deleteAction(Request $request, Tdestino $tDestino)
    {
        $form = $this->createCustomForm($tDestino->getIddestino(), 'DELETE', 'tdestino_delete');
        $form->handleRequest($request);
        $em = $this->getDoctrine()->getManager();

        if ($form->isSubmitted() && $form->isValid()) {

            if($request->isXMLHttpRequest())
            {
                $res = $this->deleteRegistro($em, $tDestino);

                return new Response(
                    json_encode(array('removed'=>$res['removed'], 'message'=>$res['message'], )),
                    200,
                    array('Content-Type'=>'application/json')
                );
            }

            $res = $this->deleteRegistro($em, $tDestino);

            $this->addFlash($res['alert'], $res['message']);

            return $this->redirectToRoute('tdestino_index');
        }
    }


}
